/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy;

import com.bea.xml.XmlException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyCustomizer;
import weblogic.wsee.security.configuration.WssConfiguration;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.policy.assertions.ConfidentialityAssertion;
import weblogic.wsee.security.policy.assertions.IdentityAssertion;
import weblogic.wsee.security.policy.assertions.IntegrityAssertion;
import weblogic.wsee.security.policy.assertions.MessageAgeAssertion;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertion;
import weblogic.wsee.security.policy.assertions.SecurityPolicyConstants;
import weblogic.wsee.security.policy.assertions.xbeans.KeyInfoType;
import weblogic.wsee.security.policy.assertions.xbeans.MessageAgeDocument;
import weblogic.wsee.security.policy.assertions.xbeans.SecurityTokenType;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.WSSecurityConfigurationException;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityTokenPolicyInfo;

public class SecurityPolicyCustomizer
implements PolicyCustomizer {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyCustomizer.class);
    private SecurityTokenPolicyInfo[] supportedTokenTypes = null;
    private WssConfiguration wssConfig;

    public SecurityPolicyCustomizer(WssConfiguration wssConfiguration) {
        this.wssConfig = wssConfiguration;
    }

    private void init() throws PolicyException {
        if (this.supportedTokenTypes == null) {
            try {
                List list = this.wssConfig.getSupprotedTokens();
                ArrayList arrayList = new ArrayList();
                for (Object e : list) {
                    if (!(e instanceof SecurityTokenPolicyInfo)) continue;
                    if (verbose) {
                        Verbose.log("Adding " + e.getClass().getName() + " to customized list since it implements SecurityTokenPolicyInfo");
                    }
                    arrayList.add(e);
                }
                this.supportedTokenTypes = arrayList.toArray(new SecurityTokenPolicyInfo[0]);
            }
            catch (WssConfigurationException wssConfigurationException) {
                throw new PolicyException(wssConfigurationException);
            }
        }
    }

    public void process(String string, PolicyStatement policyStatement) throws PolicyException {
        this.init();
        PolicyAlternative policyAlternative = SecurityPolicyCustomizer.getPolicyAlternative(string, policyStatement);
        this.handleIdentity(policyAlternative);
        this.handleIntegrity(policyAlternative);
        this.handlConfidentiality(policyAlternative);
        this.handleMessageAge(policyAlternative);
    }

    public static boolean isSecurityPolicyAbstract(String string, PolicyStatement policyStatement) throws PolicyException {
        PolicyAlternative policyAlternative = SecurityPolicyCustomizer.getPolicyAlternative(string, policyStatement);
        Set set = policyAlternative.getAssertions(IdentityAssertion.class);
        for (SecurityPolicyAssertion securityPolicyAssertion : set) {
            if (!SecurityPolicyCustomizer.isIdentityAbstract((IdentityAssertion)securityPolicyAssertion)) continue;
            return true;
        }
        set = policyAlternative.getAssertions(IntegrityAssertion.class);
        for (SecurityPolicyAssertion securityPolicyAssertion : set) {
            if (!SecurityPolicyCustomizer.isIntegrityAbstract((IntegrityAssertion)securityPolicyAssertion)) continue;
            return true;
        }
        set = policyAlternative.getAssertions(ConfidentialityAssertion.class);
        for (SecurityPolicyAssertion securityPolicyAssertion : set) {
            if (!SecurityPolicyCustomizer.isConfidentialityAbstract((ConfidentialityAssertion)securityPolicyAssertion)) continue;
            return true;
        }
        set = policyAlternative.getAssertions(MessageAgeAssertion.class);
        for (SecurityPolicyAssertion securityPolicyAssertion : set) {
            MessageAgeDocument.MessageAge messageAge = ((MessageAgeAssertion)securityPolicyAssertion).getXbean().getMessageAge();
            if (!SecurityPolicyCustomizer.isMessageAgeAbstract(messageAge)) continue;
            return true;
        }
        return false;
    }

    private static PolicyAlternative getPolicyAlternative(String string, PolicyStatement policyStatement) throws PolicyException {
        PolicyAlternative policyAlternative = policyStatement.normalize().getPolicyAlternative();
        if (policyAlternative == null) {
            throw new PolicyException("\"" + string + "\" does not contain any assertions");
        }
        return policyAlternative;
    }

    public static boolean isIdentityAbstract(IdentityAssertion identityAssertion) {
        return identityAssertion.getXbean().getIdentity().getSupportedTokens() == null;
    }

    public static boolean isIntegrityAbstract(IntegrityAssertion integrityAssertion) {
        return integrityAssertion.getXbean().getIntegrity().getSupportedTokens() == null;
    }

    public static boolean isConfidentialityAbstract(ConfidentialityAssertion confidentialityAssertion) {
        KeyInfoType keyInfoType = confidentialityAssertion.getXbean().getConfidentiality().getKeyInfo();
        if (keyInfoType == null) {
            return true;
        }
        SecurityTokenType[] securityTokenTypeArray = keyInfoType.getSecurityTokenArray();
        return securityTokenTypeArray == null || securityTokenTypeArray.length == 0;
    }

    public static boolean isMessageAgeAbstract(MessageAgeDocument.MessageAge messageAge) {
        return !messageAge.isSetAge();
    }

    private void handleIdentity(PolicyAlternative policyAlternative) throws PolicyException {
        Set set = policyAlternative.getAssertions(IdentityAssertion.class);
        for (IdentityAssertion identityAssertion : set) {
            if (!SecurityPolicyCustomizer.isIdentityAbstract(identityAssertion)) continue;
            Element element = IdentityAssertion.getElement(identityAssertion.getXbean());
            String string = DOMUtils.getPrefix("http://www.bea.com/wls90/security/policy", element);
            Element element2 = DOMUtils.createAndAddElement(element, SecurityPolicyConstants.SUPPORTED_TOKENS_QNAME, string);
            this.handleAbstractAssertions(element2, Purpose.IDENTITY);
            element.appendChild(element2);
            try {
                identityAssertion.load(element);
            }
            catch (XmlException xmlException) {
                throw new PolicyException(xmlException);
            }
        }
    }

    private void handleIntegrity(PolicyAlternative policyAlternative) throws PolicyException {
        Set set = policyAlternative.getAssertions(IntegrityAssertion.class);
        for (IntegrityAssertion integrityAssertion : set) {
            if (!SecurityPolicyCustomizer.isIntegrityAbstract(integrityAssertion)) continue;
            Element element = IntegrityAssertion.getElement(integrityAssertion.getXbean());
            String string = DOMUtils.getPrefix("http://www.bea.com/wls90/security/policy", element);
            Element element2 = DOMUtils.createAndAddElement(element, SecurityPolicyConstants.SUPPORTED_TOKENS_QNAME, string);
            this.handleAbstractAssertions(element2, Purpose.SIGN);
            element.appendChild(element2);
            try {
                integrityAssertion.load(element);
            }
            catch (XmlException xmlException) {
                throw new PolicyException(xmlException);
            }
        }
    }

    private void handlConfidentiality(PolicyAlternative policyAlternative) throws PolicyException {
        Set set = policyAlternative.getAssertions(ConfidentialityAssertion.class);
        for (ConfidentialityAssertion confidentialityAssertion : set) {
            if (!SecurityPolicyCustomizer.isConfidentialityAbstract(confidentialityAssertion) && !this.isTrustEnable(confidentialityAssertion)) continue;
            Element element = ConfidentialityAssertion.getElement(confidentialityAssertion.getXbean());
            Element element2 = (Element)DOMUtils.findNode(element, "KeyInfo");
            this.handleAbstractAssertions(element2, Purpose.ENCRYPT);
            try {
                confidentialityAssertion.load(element);
            }
            catch (XmlException xmlException) {
                throw new PolicyException(xmlException);
            }
        }
    }

    private void handleMessageAge(PolicyAlternative policyAlternative) {
        Set set = policyAlternative.getAssertions(MessageAgeAssertion.class);
        for (MessageAgeAssertion messageAgeAssertion : set) {
            MessageAgeDocument.MessageAge messageAge = messageAgeAssertion.getXbean().getMessageAge();
            if (!SecurityPolicyCustomizer.isMessageAgeAbstract(messageAge)) continue;
            messageAge.setAge(BigInteger.valueOf(this.wssConfig.getTimestampConfig().getMessageAge()));
        }
    }

    private Element handleAbstractAssertions(Element element, Purpose purpose) throws PolicyException {
        ArrayList arrayList = this.getSupportedTokenTypes(purpose);
        if (arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SecurityTokenPolicyInfo securityTokenPolicyInfo = (SecurityTokenPolicyInfo)arrayList.get(i);
                try {
                    Element element2 = securityTokenPolicyInfo.getSecurityTokenAssertion(element, purpose, this.wssConfig.getContextHandler());
                    continue;
                }
                catch (WSSecurityConfigurationException wSSecurityConfigurationException) {
                    throw new PolicyException("Failed to fill abstract token assertion.", wSSecurityConfigurationException);
                }
            }
        }
        return element;
    }

    private ArrayList getSupportedTokenTypes(Purpose purpose) {
        ArrayList<SecurityTokenPolicyInfo> arrayList = new ArrayList<SecurityTokenPolicyInfo>();
        for (int i = 0; i < this.supportedTokenTypes.length; ++i) {
            if (!this.supportedTokenTypes[i].supports(purpose)) continue;
            arrayList.add(this.supportedTokenTypes[i]);
        }
        return arrayList;
    }

    private boolean isTrustEnable(ConfidentialityAssertion confidentialityAssertion) {
        return confidentialityAssertion.getXbean().getConfidentiality().getSupportTrust10();
    }
}

