/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy;

import com.bea.xml.XmlObject;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.policy.SigningReferencesFactory;
import weblogic.wsee.security.policy.XBeanUtils;
import weblogic.wsee.security.policy.assertions.IntegrityAssertion;
import weblogic.wsee.security.policy.assertions.xbeans.IntegrityDocument;
import weblogic.wsee.security.policy.assertions.xbeans.IntegrityTargetType;
import weblogic.wsee.security.policy.assertions.xbeans.SecurityTokenType;
import weblogic.wsee.security.policy.assertions.xbeans.TransformType;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.xml.crypto.api.AlgorithmMethod;
import weblogic.xml.crypto.dsig.api.CanonicalizationMethod;
import weblogic.xml.crypto.dsig.api.DigestMethod;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignatureMethod;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.Transform;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.dsig.api.spec.TransformParameterSpec;
import weblogic.xml.crypto.dsig.api.spec.XPathFilterParameterSpec;
import weblogic.xml.crypto.wss.WSSecurityException;

public class SigningPolicy {
    private List validSignatureTokens = new ArrayList();
    private SignedInfo signedInfo;
    private boolean includeSigningTokens = false;
    private boolean X509AuthConditional = false;
    private List references = new ArrayList();
    private SignatureMethod sigMethod = null;
    private CanonicalizationMethod cMethod = null;
    private String digestAlgorithm = null;
    public static final String XPATH_TXFORM_URI = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final QName XPATH_FILTER_ELEMENT = new QName("http://www.w3.org/TR/1999/REC-xpath-19991116", "XPath");

    public SigningPolicy(XMLSignatureFactory xMLSignatureFactory, SigningReferencesFactory signingReferencesFactory, SOAPMessageContext sOAPMessageContext, Set set) throws PolicyException, SecurityPolicyException, WSSecurityException {
        for (IntegrityAssertion integrityAssertion : set) {
            AlgorithmMethod algorithmMethod;
            Object object;
            Object object2;
            Object object3;
            Map map = integrityAssertion.getNamespaceMap();
            IntegrityDocument.Integrity integrity = integrityAssertion.getXbean().getIntegrity();
            this.includeSigningTokens |= integrity.getSignToken();
            this.X509AuthConditional |= integrity.getX509AuthConditional();
            if (!integrity.isSetSupportedTokens()) {
                throw new PolicyException("Supportedtokens element is missing from Integrity assertion");
            }
            SecurityTokenType[] securityTokenTypeArray = integrity.getSupportedTokens().getSecurityTokenArray();
            for (int i = 0; i < securityTokenTypeArray.length; ++i) {
                object3 = securityTokenTypeArray[i];
                object2 = new SecurityToken(XBeanUtils.getElement((XmlObject)object3), null, object3.getTokenType(), object3.getIncludeInMessage());
                ((SecurityToken)object2).setDerivedFromTokenType(object3.getDerivedFromTokenType());
                this.validSignatureTokens.add(object2);
            }
            IntegrityTargetType[] integrityTargetTypeArray = integrity.getTargetArray();
            for (int i = 0; i < integrityTargetTypeArray.length; ++i) {
                Object object4;
                object2 = integrityTargetTypeArray[i];
                object = null;
                algorithmMethod = null;
                try {
                    object = SigningPolicy.processSigningTransforms(xMLSignatureFactory, (IntegrityTargetType)object2);
                    object4 = object2.getDigestAlgorithm().getURI();
                    this.digestAlgorithm = object4;
                    algorithmMethod = xMLSignatureFactory.newDigestMethod((String)object4, null);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new SecurityPolicyException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new SecurityPolicyException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
                }
                object4 = signingReferencesFactory.getSigningReferences(xMLSignatureFactory, object2.getMessageParts(), (DigestMethod)algorithmMethod, (List)object, sOAPMessageContext, map);
                this.references.addAll(object4);
            }
            object3 = integrity.getCanonicalizationAlgorithm().getURI();
            object2 = null;
            try {
                object2 = xMLSignatureFactory.newCanonicalizationMethod((String)object3, null);
                if (this.cMethod == null) {
                    this.cMethod = object2;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new WSSecurityException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new WSSecurityException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
            }
            object = integrity.getSignatureAlgorithm().getURI();
            algorithmMethod = null;
            try {
                algorithmMethod = xMLSignatureFactory.newSignatureMethod((String)object, null);
                if (this.sigMethod != null) continue;
                this.sigMethod = algorithmMethod;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new WSSecurityException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new WSSecurityException(invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
            }
        }
        this.signedInfo = xMLSignatureFactory.newSignedInfo(this.cMethod, this.sigMethod, this.references);
    }

    public SignedInfo newSignedInfo(XMLSignatureFactory xMLSignatureFactory, Reference reference) {
        ArrayList<Reference> arrayList = new ArrayList<Reference>(this.references);
        arrayList.add(reference);
        return xMLSignatureFactory.newSignedInfo(this.cMethod, this.sigMethod, arrayList);
    }

    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }

    public List getValidSignatureTokens() {
        return this.validSignatureTokens;
    }

    public boolean signedSecurityTokens() {
        return this.includeSigningTokens;
    }

    public boolean isX509AuthConditional() {
        return this.X509AuthConditional;
    }

    private static List processSigningTransforms(XMLSignatureFactory xMLSignatureFactory, IntegrityTargetType integrityTargetType) throws SecurityPolicyException {
        ArrayList<Transform> arrayList = new ArrayList<Transform>();
        TransformType[] transformTypeArray = integrityTargetType.getTransformArray();
        for (int i = 0; i < transformTypeArray.length; ++i) {
            TransformType transformType = transformTypeArray[i];
            String string = DOMUtils.getAttributeValueAsString(XBeanUtils.getElement(transformType), new QName("URI"));
            if (string == null) {
                throw new SecurityPolicyException("Could not read Transform URI from Transform element");
            }
            TransformParameterSpec transformParameterSpec = null;
            DocumentFragment documentFragment = XBeanUtils.getXMLBeanChildren(transformType);
            if (XPATH_TXFORM_URI.equals(string)) {
                transformParameterSpec = SigningPolicy.createXPathFilterSpec(documentFragment);
                if (transformParameterSpec == null) {
                    throw new SecurityPolicyException("No XPath transform parameter.");
                }
            } else {
                transformParameterSpec = new DOMParameterSpec(documentFragment);
            }
            try {
                arrayList.add(xMLSignatureFactory.newTransform(string, transformParameterSpec));
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SecurityPolicyException(noSuchAlgorithmException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new SecurityPolicyException(invalidAlgorithmParameterException);
            }
        }
        if (arrayList.size() == 0) {
            try {
                arrayList.add(xMLSignatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", null));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public String getDigestAlgorithm() {
        if (null != this.digestAlgorithm) {
            return this.digestAlgorithm;
        }
        return "http://www.w3.org/2000/09/xmldsig#sha1";
    }

    private static XPathFilterParameterSpec createXPathFilterSpec(DocumentFragment documentFragment) {
        NodeList nodeList = documentFragment.getChildNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        Element element = (Element)nodeList.item(0);
        String string = DOMUtils.getTextContent(element, true);
        return new XPathFilterParameterSpec(string);
    }

    private static class DOMParameterSpec
    implements TransformParameterSpec {
        private DocumentFragment fragment;

        public DOMParameterSpec(DocumentFragment documentFragment) {
            this.fragment = documentFragment;
        }

        public DocumentFragment getDocumentFragment() {
            return this.fragment;
        }
    }
}

