/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.w3c.dom.Element;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy.MessagePartsEvaluator;
import weblogic.wsee.security.policy.SecurityToken;
import weblogic.wsee.security.policy.assertions.xbeans.MessagePartsType;
import weblogic.xml.crypto.dsig.api.DigestMethod;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.wss.SecurityBuilder;
import weblogic.xml.crypto.wss.SecurityValidator;
import weblogic.xml.crypto.wss.WSSecurityException;

public class SigningReferencesFactory {
    private SecurityBuilder sbuilder;
    private SecurityValidator svalidator;

    public SigningReferencesFactory(SecurityBuilder securityBuilder) {
        this.sbuilder = securityBuilder;
    }

    public SigningReferencesFactory(SecurityValidator securityValidator) {
        this.svalidator = securityValidator;
    }

    public Reference newSigningTokenReference(SecurityToken securityToken, ContextHandler contextHandler, String string) throws WSSecurityException {
        XMLSignatureFactory xMLSignatureFactory;
        Reference reference = null;
        if (this.sbuilder != null) {
            xMLSignatureFactory = this.sbuilder.getXMLSignatureFactory();
            try {
                reference = this.sbuilder.createReference(securityToken.getTokenTypeUri(), securityToken.getIssuerName(), xMLSignatureFactory.newDigestMethod(string, null), new ArrayList(), securityToken.isIncludeInMessage(), contextHandler);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new WSSecurityException(noSuchAlgorithmException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new WSSecurityException(invalidAlgorithmParameterException);
            }
        }
        if (this.svalidator != null) {
            xMLSignatureFactory = this.svalidator.getXMLSignatureFactory();
            try {
                reference = this.svalidator.getReference(securityToken.getTokenTypeUri(), securityToken.getIssuerName(), securityToken.getClaims(), xMLSignatureFactory.newDigestMethod(string, null), new ArrayList(), securityToken.isIncludeInMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new WSSecurityException(noSuchAlgorithmException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new WSSecurityException(invalidAlgorithmParameterException);
            }
        }
        return reference;
    }

    public List getSigningReferences(XMLSignatureFactory xMLSignatureFactory, MessagePartsType messagePartsType, DigestMethod digestMethod, List list, SOAPMessageContext sOAPMessageContext, Map map) throws WSSecurityException, PolicyException {
        List list2 = new MessagePartsEvaluator(messagePartsType, sOAPMessageContext, map).getNodes();
        return this.getSigningReferences(xMLSignatureFactory, list2, digestMethod, list);
    }

    public List getSigningReferences(XMLSignatureFactory xMLSignatureFactory, List list, DigestMethod digestMethod, List list2) throws WSSecurityException, PolicyException {
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        for (Element element : list) {
            String string = null;
            string = this.sbuilder != null ? this.sbuilder.assignUri(element) : this.svalidator.getUri(element);
            arrayList.add(xMLSignatureFactory.newReference(string, digestMethod, list2, null, null));
        }
        return arrayList;
    }
}

