/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy;

import java.io.Serializable;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.security.configuration.WssConfiguration;
import weblogic.wsee.security.policy.SecurityPolicyCustomizer;

public class WssPolicyContext
implements Serializable {
    private static final long serialVersionUID = -1405648915117924659L;
    public static final String WSS_POLICY_CTX_PROP = "weblogic.weblogic.wsee.security.policy.WssPolicyCtx";
    private String wssConfigMBeanName;
    private boolean isServer;
    private transient PolicyServer ps;
    private transient WssConfiguration wssConfig;

    public WssPolicyContext() {
        this.init(this.wssConfigMBeanName, true, true);
    }

    public WssPolicyContext(String string) {
        this.init(string, true, true);
    }

    public WssPolicyContext(boolean bl) {
        this.init(null, bl, true);
    }

    public WssPolicyContext(String string, boolean bl) {
        this.init(string, bl, true);
    }

    public WssPolicyContext(String string, boolean bl, boolean bl2) {
        this.init(string, bl, bl2);
    }

    private void init(String string, boolean bl, boolean bl2) {
        this.wssConfigMBeanName = string;
        this.isServer = bl;
        this.ps = new PolicyServer();
        this.wssConfig = new WssConfiguration(this.wssConfigMBeanName, bl);
        if (bl2) {
            SecurityPolicyCustomizer securityPolicyCustomizer = new SecurityPolicyCustomizer(this.wssConfig);
            this.ps.addPolicyCustomizer(securityPolicyCustomizer);
        }
    }

    public PolicyServer getPolicyServer() {
        if (this.ps == null) {
            this.init(this.wssConfigMBeanName, this.isServer, true);
        }
        return this.ps;
    }

    public WssConfiguration getWssConfiguration() {
        if (this.wssConfig == null) {
            this.init(this.wssConfigMBeanName, this.isServer, true);
        }
        return this.wssConfig;
    }
}

