/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyMath;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertionFactory;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.dispatch.Dispatcher;

public final class WssPolicyUtils {
    private static final WssPolicyContext policyCtx = new WssPolicyContext();

    public static NormalizedExpression getPolicy(String string) throws PolicyException {
        return WssPolicyUtils.getPolicy(policyCtx, string);
    }

    public static NormalizedExpression getPolicy(WssPolicyContext wssPolicyContext, String string) throws PolicyException {
        if (wssPolicyContext == null) {
            wssPolicyContext = policyCtx;
        }
        return wssPolicyContext.getPolicyServer().getPolicy(string).normalize();
    }

    public static NormalizedExpression getPolicy(String[] stringArray) throws PolicyException {
        return WssPolicyUtils.getPolicy(policyCtx, stringArray);
    }

    public static NormalizedExpression getPolicy(WssPolicyContext wssPolicyContext, String[] stringArray) throws PolicyException {
        if (wssPolicyContext == null) {
            wssPolicyContext = policyCtx;
        }
        NormalizedExpression normalizedExpression = NormalizedExpression.createUnitializedExpression();
        for (int i = 0; i < stringArray.length; ++i) {
            normalizedExpression = PolicyMath.merge(normalizedExpression, WssPolicyUtils.getPolicy(wssPolicyContext, stringArray[i]));
        }
        return normalizedExpression;
    }

    public static WssPolicyContext getContext() {
        return policyCtx;
    }

    public static List getCredentialProviders() throws WssConfigurationException {
        return policyCtx.getWssConfiguration().getCredentialProviders();
    }

    public static WsdlPolicySubject getWsdlPolicySubject(MessageContext messageContext) {
        WlMessageContext wlMessageContext = null;
        try {
            wlMessageContext = (WlMessageContext)messageContext;
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError((Object)classCastException);
        }
        Dispatcher dispatcher = wlMessageContext.getDispatcher();
        if (dispatcher != null) {
            WsService wsService = dispatcher.getWsPort().getEndpoint().getService();
            return new WsdlPolicySubject(wsService.getWsdlService().getDefinitions(), wsService.getPolicyServer());
        }
        return null;
    }

    public static boolean hasSecurityPolicy(WsdlPolicySubject wsdlPolicySubject) throws PolicyException {
        if (wsdlPolicySubject == null) {
            return false;
        }
        Map map = wsdlPolicySubject.getAllEffectivePolicies();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            if (!SecurityPolicyAssertionFactory.hasSecurityPolicy((NormalizedExpression)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSecurityPolicy(MessageContext messageContext) throws PolicyException {
        return WssPolicyUtils.hasSecurityPolicy(WssPolicyUtils.getWsdlPolicySubject(messageContext));
    }
}

