/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy.assertions;

import com.bea.xml.XmlException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.policy.framework.ExternalizationUtils;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertion;
import weblogic.wsee.security.policy.assertions.xbeans.IdentityDocument;

public class IdentityAssertion
extends SecurityPolicyAssertion {
    public static final QName NAME = new QName("http://www.bea.com/wls90/security/policy", "Identity");
    private IdentityDocument xbean;

    public IdentityAssertion() {
    }

    IdentityAssertion(IdentityDocument identityDocument) {
        if (identityDocument == null) {
            throw new AssertionError();
        }
        this.xbean = identityDocument;
    }

    public IdentityDocument getXbean() {
        return this.xbean;
    }

    public void load(Node node) throws XmlException {
        this.xbean = IdentityDocument.Factory.parse(node);
    }

    public Element serialize(Document document) throws PolicyException {
        Element element = IdentityAssertion.getElement(this.xbean);
        if (document == null) {
            return element;
        }
        return (Element)document.importNode(element, true);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IdentityAssertion)) {
            return false;
        }
        IdentityAssertion identityAssertion = (IdentityAssertion)object;
        return this.xbean.equals(identityAssertion.xbean);
    }

    public int hashCode() {
        return this.xbean.hashCode();
    }

    public QName getName() {
        return NAME;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.xbean = (IdentityDocument)ExternalizationUtils.readXmlObject(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        ExternalizationUtils.writeXmlObject(this.xbean, objectOutput);
    }
}

