/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy.assertions;

import com.bea.xml.XmlException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.policy.framework.ExternalizationUtils;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertion;
import weblogic.wsee.security.policy.assertions.xbeans.IntegrityDocument;
import weblogic.xml.dom.NamespaceUtils;

public class IntegrityAssertion
extends SecurityPolicyAssertion {
    public static final QName NAME = new QName("http://www.bea.com/wls90/security/policy", "Integrity");
    private IntegrityDocument xbean;
    private Map namespaceMap;

    public IntegrityAssertion() {
    }

    IntegrityAssertion(IntegrityDocument integrityDocument, Map map) {
        if (integrityDocument == null) {
            throw new AssertionError();
        }
        this.xbean = integrityDocument;
        this.namespaceMap = map;
    }

    public IntegrityDocument getXbean() {
        return this.xbean;
    }

    public void load(Node node) throws XmlException {
        this.xbean = IntegrityDocument.Factory.parse(node);
    }

    public Map getNamespaceMap() {
        return this.namespaceMap;
    }

    public Element serialize(Document document) throws PolicyException {
        Element element = IntegrityAssertion.getElement(this.xbean);
        if (document != null) {
            element = (Element)document.importNode(element, true);
        }
        for (String string : this.namespaceMap.keySet()) {
            String string2;
            if (string == null || string.length() == 0 || prefixesMap.get(string2 = (String)this.namespaceMap.get(string)) != null) continue;
            NamespaceUtils.defineNamespace((Element)element, (String)string, (String)string2);
        }
        return element;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntegrityAssertion)) {
            return false;
        }
        IntegrityAssertion integrityAssertion = (IntegrityAssertion)object;
        return this.xbean.equals(integrityAssertion.xbean);
    }

    public int hashCode() {
        return this.xbean.hashCode();
    }

    public QName getName() {
        return NAME;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.xbean = (IntegrityDocument)ExternalizationUtils.readXmlObject(objectInput);
        this.namespaceMap = (HashMap)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        ExternalizationUtils.writeXmlObject(this.xbean, objectOutput);
        objectOutput.writeObject(this.namespaceMap);
    }
}

