/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy.assertions;

import com.bea.xml.XmlException;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.ExternalizationUtils;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyAssertionFactory;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.security.policy.assertions.ConfidentialityAssertion;
import weblogic.wsee.security.policy.assertions.IdentityAssertion;
import weblogic.wsee.security.policy.assertions.IntegrityAssertion;
import weblogic.wsee.security.policy.assertions.MessageAgeAssertion;
import weblogic.wsee.security.policy.assertions.xbeans.ConfidentialityDocument;
import weblogic.wsee.security.policy.assertions.xbeans.IdentityDocument;
import weblogic.wsee.security.policy.assertions.xbeans.IntegrityDocument;
import weblogic.wsee.security.policy.assertions.xbeans.MessageAgeDocument;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;

public class SecurityPolicyAssertionFactory
extends PolicyAssertionFactory {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyAssertionFactory.class);

    public PolicyAssertion createAssertion(Node node) throws PolicyException {
        Map<String, String> map = DOMUtils.getNamespaceMapping(node);
        if (verbose) {
            Verbose.log("SecurityPolicyAssertionFactory.createAssertion(" + DOMUtils.getQNameOf(node) + ")");
        }
        try {
            return new IdentityAssertion(IdentityDocument.Factory.parse(node));
        }
        catch (XmlException xmlException) {
            try {
                return new IntegrityAssertion(IntegrityDocument.Factory.parse(node), map);
            }
            catch (XmlException xmlException2) {
                try {
                    return new ConfidentialityAssertion(ConfidentialityDocument.Factory.parse(node), map);
                }
                catch (XmlException xmlException3) {
                    try {
                        return new MessageAgeAssertion(MessageAgeDocument.Factory.parse(node));
                    }
                    catch (XmlException xmlException4) {
                        return null;
                    }
                }
            }
        }
    }

    public static boolean hasSecurityPolicy(WsPort wsPort, PolicyServer policyServer) throws PolicyException {
        boolean bl = false;
        Iterator iterator = wsPort.getEndpoint().getMethods();
        while (iterator.hasNext()) {
            WsMethod wsMethod = (WsMethod)iterator.next();
            if (SecurityPolicyAssertionFactory.hasSecurityPolicy(PolicyContext.getRequestEffectivePolicy(wsPort, wsMethod, policyServer, policyServer.getCachedPolicies()))) {
                bl = true;
            }
            if (!SecurityPolicyAssertionFactory.hasSecurityPolicy(PolicyContext.getResponseEffectivePolicy(wsPort, wsMethod, policyServer, policyServer.getCachedPolicies()))) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean hasSecurityPolicy(NormalizedExpression normalizedExpression) {
        if (null == normalizedExpression) {
            throw new IllegalArgumentException("Null policy found");
        }
        return normalizedExpression.containsPolicyAssertion(MessageAgeAssertion.class) || normalizedExpression.containsPolicyAssertion(IdentityAssertion.class) || normalizedExpression.containsPolicyAssertion(IntegrityAssertion.class) || normalizedExpression.containsPolicyAssertion(ConfidentialityAssertion.class);
    }

    public static boolean hasSecurityPolicy(PolicyAlternative policyAlternative) {
        if (null == policyAlternative) {
            return false;
        }
        return !policyAlternative.getAssertions(MessageAgeAssertion.class).isEmpty() || !policyAlternative.getAssertions(IdentityAssertion.class).isEmpty() || !policyAlternative.getAssertions(IntegrityAssertion.class).isEmpty() || !policyAlternative.getAssertions(ConfidentialityAssertion.class).isEmpty();
    }

    public static boolean isWSTEnabled(WsPort wsPort, PolicyServer policyServer) throws PolicyException {
        boolean bl = false;
        Iterator iterator = wsPort.getEndpoint().getMethods();
        while (iterator.hasNext()) {
            WsMethod wsMethod = (WsMethod)iterator.next();
            if (SecurityPolicyAssertionFactory.isWSTEnabled(PolicyContext.getRequestEffectivePolicy(wsPort, wsMethod, policyServer, policyServer.getCachedPolicies()))) {
                bl = true;
            }
            if (!SecurityPolicyAssertionFactory.isWSTEnabled(PolicyContext.getResponseEffectivePolicy(wsPort, wsMethod, policyServer, policyServer.getCachedPolicies()))) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean isWSTEnabled(NormalizedExpression normalizedExpression) {
        ConfidentialityDocument.Confidentiality confidentiality;
        Object object;
        IntegrityAssertion integrityAssertion = (IntegrityAssertion)normalizedExpression.getPolicyAssertion(IntegrityAssertion.class);
        if (integrityAssertion != null && (object = integrityAssertion.getXbean().getIntegrity()).getSupportTrust10()) {
            return true;
        }
        object = (ConfidentialityAssertion)normalizedExpression.getPolicyAssertion(ConfidentialityAssertion.class);
        return object != null && (confidentiality = ((ConfidentialityAssertion)object).getXbean().getConfidentiality()).getSupportTrust10();
    }

    static {
        ExternalizationUtils.registerExternalizable(ConfidentialityAssertion.NAME, ConfidentialityAssertion.class.getName());
        ExternalizationUtils.registerExternalizable(IdentityAssertion.NAME, IdentityAssertion.class.getName());
        ExternalizationUtils.registerExternalizable(IntegrityAssertion.NAME, IntegrityAssertion.class.getName());
        ExternalizationUtils.registerExternalizable(MessageAgeAssertion.NAME, MessageAgeAssertion.class.getName());
    }
}

