/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy.assertions;

import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.kernel.KernelStatus;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.provider.PolicyValidationHandler;
import weblogic.wsee.security.policy.assertions.IdentityAssertion;
import weblogic.wsee.security.policy.assertions.IntegrityAssertion;
import weblogic.wsee.security.policy.assertions.xbeans.IdentityDocument;
import weblogic.wsee.security.policy.assertions.xbeans.SecurityTokenType;
import weblogic.wsee.security.policy.assertions.xbeans.SupportedTokensType;
import weblogic.wsee.security.saml.SAMLConstants;
import weblogic.xml.crypto.wss.SecurityUtils;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.policy.ClaimsBuilder;

public class SecurityPolicyDeploymentValidationHandler
implements PolicyValidationHandler {
    public boolean validate(String string, PolicyStatement policyStatement) throws PolicyException {
        PolicyAlternative policyAlternative = policyStatement.normalize().getPolicyAlternative();
        if (policyAlternative == null || policyAlternative.isEmpty()) {
            throw new PolicyException("\"" + string + "\" does not contain any assertions");
        }
        this.validateIdentityAssertion(string, policyAlternative);
        this.validateIntegrityAssertion(policyAlternative);
        return true;
    }

    private void validateIntegrityAssertion(PolicyAlternative policyAlternative) throws PolicyException {
        Set set = policyAlternative.getAssertions(IntegrityAssertion.class);
        for (IntegrityAssertion integrityAssertion : set) {
            SupportedTokensType supportedTokensType = integrityAssertion.getXbean().getIntegrity().getSupportedTokens();
            if (supportedTokensType == null) continue;
            SecurityTokenType[] securityTokenTypeArray = supportedTokensType.getSecurityTokenArray();
            for (int i = 0; i < securityTokenTypeArray.length; ++i) {
                if (!securityTokenTypeArray[i].getTokenType().equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID")) continue;
                SecurityPolicyDeploymentValidationHandler.validateSAMLTokenType(securityTokenTypeArray[i]);
            }
        }
    }

    private void validateIdentityAssertion(String string, PolicyAlternative policyAlternative) throws PolicyException {
        Set set = policyAlternative.getAssertions(IdentityAssertion.class);
        for (IdentityAssertion identityAssertion : set) {
            IdentityDocument.Identity identity = identityAssertion.getXbean().getIdentity();
            SupportedTokensType supportedTokensType = identity.getSupportedTokens();
            if (supportedTokensType == null) continue;
            SecurityTokenType[] securityTokenTypeArray = supportedTokensType.getSecurityTokenArray();
            for (int i = 0; i < securityTokenTypeArray.length; ++i) {
                if (securityTokenTypeArray[i].getTokenType().equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID")) {
                    SecurityPolicyDeploymentValidationHandler.validateSAMLTokenType(securityTokenTypeArray[i]);
                    continue;
                }
                if (!securityTokenTypeArray[i].getTokenType().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken")) continue;
                SecurityPolicyDeploymentValidationHandler.validateUsernameTokenType(string, securityTokenTypeArray[i]);
            }
        }
    }

    private static void validateUsernameTokenType(String string, SecurityTokenType securityTokenType) throws PolicyException {
        if (!KernelStatus.isServer()) {
            return;
        }
        Element element = (Element)securityTokenType.newDomNode().getFirstChild();
        NodeList nodeList = element.getElementsByTagNameNS("http://www.bea.com/wls90/security/policy", WSSConstants.POLICY_USE_PASSWD_QNAME.getLocalPart());
        if (nodeList != null && nodeList.getLength() > 0) {
            String string2 = DOMUtils.getAttributeValueAsString((Element)nodeList.item(0), WSSConstants.TYPE_QNAME);
            if (string2 == null || string2.length() == 0) {
                throw new PolicyException(string + " is not valid: " + "'Type' attribute of 'UsePassword' is not specified.");
            }
            if (string2.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest") && !SecurityUtils.isPasswordDigestSupported()) {
                throw new PolicyException(string + " is not valid: " + " server is not configured to support Password Digest. Specify 'PasswordText' instead.");
            }
        }
    }

    private static void validateSAMLTokenType(SecurityTokenType securityTokenType) throws PolicyException {
        Element element = (Element)securityTokenType.newDomNode().getFirstChild();
        if (element == null) {
            throw new PolicyException("Claims of SAML token must not be null");
        }
        String string = ClaimsBuilder.getClaimFromElt((Node)element, SAMLConstants.CONFIRMATION_METHOD_QNAME);
        if (string == null) {
            throw new PolicyException("ConfirmationMethod of saml token is not specified.");
        }
        if (!string.equals("holder-of-key") && !string.equals("sender-vouches")) {
            throw new PolicyException(string + " is not a valid subject confirmation method");
        }
    }
}

