/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy.assertions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.provider.ServiceConfigurationHandler;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertionFactory;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.init.WsDeploymentContext;

public class WssServiceConfigHandler
implements ServiceConfigurationHandler {
    public void process(WsDeploymentContext wsDeploymentContext) throws PolicyException {
        this.deployWssHandlers(wsDeploymentContext);
    }

    private void deployWssHandlers(WsDeploymentContext wsDeploymentContext) throws PolicyException {
        WsService wsService = wsDeploymentContext.getWsService();
        boolean bl = wsService.isUsingPolicy();
        if (!bl) {
            return;
        }
        PolicyServer policyServer = wsService.getPolicyServer();
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            HandlerList handlerList = wsPort.getInternalHandlerList();
            if (SecurityPolicyAssertionFactory.hasSecurityPolicy(wsPort, policyServer)) {
                this.insertWssHandlers(handlerList);
                try {
                    wsService.initWssConfiguration();
                }
                catch (WssConfigurationException wssConfigurationException) {
                    throw new PolicyException(wssConfigurationException);
                }
            }
            if (!SecurityPolicyAssertionFactory.isWSTEnabled(wsPort, policyServer)) continue;
            this.insertSTSPolicyHandler(handlerList);
            this.insertSTSMessageHandler(handlerList);
        }
    }

    private void insertSTSMessageHandler(HandlerList handlerList) throws PolicyException {
        List<Object> list = Arrays.asList((Object[])new String[]{"ADDRESSING_HANDLER"});
        List<Object> list2 = Arrays.asList((Object[])new String[]{"OPERATION_LOOKUP_HANDLER"});
        try {
            HandlerInfo handlerInfo = WssServiceConfigHandler.getWstHandlerInfo();
            handlerList.insert("WS_TRUST_STS_HANDLER", handlerInfo, list, list2);
        }
        catch (HandlerException handlerException) {
            throw new PolicyException("Failed to deploy WSTServerHandler: " + handlerException.getMessage());
        }
    }

    private void insertSTSPolicyHandler(HandlerList handlerList) throws PolicyException {
        List<Object> list = Arrays.asList((Object[])new String[]{"CONNECTION_HANDLER"});
        List<Object> list2 = Arrays.asList((Object[])new String[]{"SECURITY_HANDLER"});
        try {
            HandlerInfo handlerInfo = WssServiceConfigHandler.getStsPolicyHandlerInfo();
            handlerList.insert("WS_TRUST_POLICY_HANDLER", handlerInfo, list, list2);
        }
        catch (HandlerException handlerException) {
            throw new PolicyException("Failed to deploy WSTServerHandler: " + handlerException.getMessage());
        }
    }

    private void insertWssHandlers(HandlerList handlerList) throws PolicyException {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Object> list = Arrays.asList((Object[])new String[]{"CONNECTION_HANDLER", "FORWARDING_HANDLER"});
        List<Object> list2 = Arrays.asList((Object[])new String[]{"OPERATION_LOOKUP_HANDLER", "FORWARDING_HANDLER"});
        HandlerInfo handlerInfo = this.getWssHandlerInfo();
        HandlerInfo handlerInfo2 = this.getPolicyHandlerInfo();
        try {
            handlerList.lenientInsert("SECURITY_HANDLER", handlerInfo, list, arrayList);
            handlerList.lenientInsert("SECURITY_SERVER_POLICY_HANDLER", handlerInfo2, list2, arrayList);
        }
        catch (HandlerException handlerException) {
            throw new PolicyException(handlerException);
        }
    }

    private HandlerInfo getWssHandlerInfo() throws PolicyException {
        HashMap hashMap = new HashMap();
        try {
            return new HandlerInfo(Class.forName("weblogic.wsee.security.WssServerHandler"), hashMap, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PolicyException(classNotFoundException);
        }
    }

    private HandlerInfo getPolicyHandlerInfo() throws PolicyException {
        HashMap hashMap = new HashMap();
        try {
            return new HandlerInfo(Class.forName("weblogic.wsee.security.WssServerPolicyHandler"), hashMap, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PolicyException(classNotFoundException);
        }
    }

    private static final HandlerInfo getWstHandlerInfo() throws PolicyException {
        HashMap hashMap = new HashMap();
        try {
            return new HandlerInfo(Class.forName("weblogic.wsee.security.wst.internal.STSMessageHandler"), hashMap, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PolicyException(classNotFoundException);
        }
    }

    private static final HandlerInfo getStsPolicyHandlerInfo() throws PolicyException {
        HashMap hashMap = new HashMap();
        try {
            return new HandlerInfo(Class.forName("weblogic.wsee.security.wst.internal.STSPolicyHandler"), hashMap, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PolicyException(classNotFoundException);
        }
    }
}

