/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy11.assertions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyException;

public class HttpsToken
extends weblogic.wsee.security.policy12.assertions.HttpsToken {
    private static final long serialVersionUID = 1335615639315668760L;
    public static final QName REQ_CLIENT_CERT = new QName("RequireClientCertificate");
    boolean isClientCertRequired = false;

    protected void init(Element element) throws PolicyException {
        super.init(element);
        Boolean bl = DOMUtils.getAttributeValueAsBoolean(element, REQ_CLIENT_CERT);
        if (bl != null) {
            this.isClientCertRequired = bl;
        }
    }

    public boolean isClientCertRequired() {
        return this.isClientCertRequired;
    }

    public Element serialize(Document document) throws PolicyException {
        Element element = super.serialize(document);
        DOMUtils.addAttribute(element, REQ_CLIENT_CERT, String.valueOf(this.isClientCertRequired));
        return element;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.isClientCertRequired = objectInput.readBoolean();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeBoolean(this.isClientCertRequired);
    }
}

