/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.security.policy12.assertions.SecurityPolicy12Assertion;
import weblogic.wsee.wsa.wsaddressing.WSAddressingConstants;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class Address
extends SecurityPolicy12Assertion {
    private static final long serialVersionUID = -3037820652713414785L;
    private QName name = WSAddressingConstants.ISSUE_ADDRESS_QNAME_10;
    private String address = null;

    void initAssertion(Element element) throws PolicyException {
        Object object;
        if ("Address".equals(element.getLocalName())) {
            this.address = DOMUtils.getTextContent(element, true);
            this.name = "http://www.w3.org/2005/08/addressing".equals(element.getNamespaceURI()) ? WSAddressingConstants.ISSUE_ADDRESS_QNAME_10 : ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(element.getNamespaceURI()) ? WSAddressingConstants.ISSUE_ADDRESS_QNAME : new QName(element.getNamespaceURI(), element.getLocalName(), element.getPrefix()));
        } else {
            try {
                object = DOMUtils.getOptionalElementByTagNameNS(element, "http://www.w3.org/2005/08/addressing", "Address");
                if (object != null) {
                    this.address = DOMUtils.getTextContent((Element)object, true);
                    this.name = WSAddressingConstants.ISSUE_ADDRESS_QNAME_10;
                    return;
                }
                object = DOMUtils.getElementByTagNameNS(element, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address");
                if (object != null) {
                    this.address = DOMUtils.getTextContent((Element)object, true);
                    this.name = WSAddressingConstants.ISSUE_ADDRESS_QNAME;
                }
            }
            catch (DOMProcessingException dOMProcessingException) {
                throw new PolicyException((Throwable)((Object)dOMProcessingException));
            }
        }
        object = PolicyHelper.getOptionalPolicyNamespaceUri(element);
        if (null != object) {
            this.setPolicyNamespaceUri((String)object);
            this.setOptional(true);
        }
    }

    public Element serialize(Document document) throws PolicyException {
        Element element = weblogic.wsee.policy.framework.DOMUtils.createElement(this.name, document, this.name.getPrefix());
        if (this.optional) {
            PolicyHelper.addOptionalAttribute(element, this.getPolicyNamespaceUri());
        }
        return this.serializeAssertion(document, element);
    }

    Element serializeAssertion(Document document, Element element) throws PolicyException {
        DOMUtils.addTextData(element, this.address);
        return element;
    }

    public QName getName() {
        return this.name;
    }

    public String getEndpointAddress() {
        return this.address;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.address = objectInput.readUTF();
        String string = objectInput.readUTF();
        if ("http://www.w3.org/2005/08/addressing".equals(string)) {
            this.name = WSAddressingConstants.ISSUE_ADDRESS_QNAME_10;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(string)) {
            this.name = WSAddressingConstants.ISSUE_ADDRESS_QNAME;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.address);
        objectOutput.writeUTF(this.name.getNamespaceURI());
    }
}

