/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import weblogic.wsee.security.policy12.assertions.XPathElements;
import weblogic.wsee.security.wss.plan.helper.XpathNodesHelper;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedElements
extends XPathElements {
    public static final String ENCRYPTED_ELEMENTS = "EncryptedElements";

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public QName getName() {
        return new QName(this.getNamespace(), ENCRYPTED_ELEMENTS, "sp");
    }

    public static void isValidElement(List<Node> list, boolean bl) throws SecurityPolicyArchitectureException {
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            EncryptedElements.isValidElement(node, bl);
        }
    }

    public static void isValidElement(Node node, boolean bl) throws SecurityPolicyArchitectureException {
        String string = XpathNodesHelper.getElementPath(node);
        if (string == null) {
            return;
        }
        if (!string.startsWith("/http://schemas.xmlsoap.org/soap/envelope/:Envelope/") && !string.startsWith("/http://www.w3.org/2003/05/soap-envelope:Envelope/")) {
            throw new SecurityPolicyArchitectureException("Error validating EncryptedElement assertion for element <" + string + ">: nodelist does not contain a SOAP Envelope element");
        }
        if (!(bl || string.compareTo("/http://schemas.xmlsoap.org/soap/envelope/:Envelope/http://schemas.xmlsoap.org/soap/envelope/:Body") != 0 && string.compareTo("/http://www.w3.org/2003/05/soap-envelope:Envelope/http://www.w3.org/2003/05/soap-envelope:Body") != 0)) {
            throw new SecurityPolicyArchitectureException("Error validating EncryptedElement assertion for element <" + string + ">: EncryptedElement assertion may not encrypt the entire SOAPBody element");
        }
        if (string.compareTo("/http://schemas.xmlsoap.org/soap/envelope/:Envelope/http://schemas.xmlsoap.org/soap/envelope/:Header") == 0 || string.compareTo("/http://www.w3.org/2003/05/soap-envelope:Envelope/http://www.w3.org/2003/05/soap-envelope:Header") == 0) {
            throw new SecurityPolicyArchitectureException("Error validating EncryptedElement assertion for element <" + string + ">: EncryptedElement assertion may not encrypt the entire SOAPHeader element");
        }
        if ((string.startsWith("/http://schemas.xmlsoap.org/soap/envelope/:Envelope/http://schemas.xmlsoap.org/soap/envelope/:Header") || string.startsWith("/http://www.w3.org/2003/05/soap-envelope:Envelope/http://www.w3.org/2003/05/soap-envelope:Header")) && node.getLocalName().compareTo("Security") == 0 && node.getNamespaceURI().compareTo("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") == 0) {
            throw new SecurityPolicyArchitectureException("Error validating EncryptedElement assertion for element <" + string + ">: the wsse:Security header may not be encrypted");
        }
    }
}

