/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.security.policy12.assertions.SecurityPolicy12Assertion;

public class Header
extends SecurityPolicy12Assertion {
    private static final long serialVersionUID = 5969917487655147126L;
    public static final String HEADER = "Header";
    private static final QName NAME = new QName("Name");
    private static final QName NAMESPACE = new QName("Namespace");
    private String headerName;
    private String namespaceUri;

    public String getHeaderName() {
        return this.headerName;
    }

    public String getHeaderNamespaceUri() {
        return this.namespaceUri;
    }

    public QName getName() {
        return new QName(this.getNamespace(), HEADER, "sp");
    }

    void initAssertion(Element element) throws PolicyException {
        this.headerName = DOMUtils.getAttributeValueAsString(element, NAME);
        this.namespaceUri = DOMUtils.getAttributeValueAsString(element, NAMESPACE);
        String string = PolicyHelper.getOptionalPolicyNamespaceUri(element);
        if (null != string) {
            this.setPolicyNamespaceUri(string);
            this.setOptional(true);
        }
    }

    Element serializeAssertion(Document document, Element element) throws PolicyException {
        if (this.headerName != null && this.headerName.length() > 0) {
            DOMUtils.addAttribute(element, NAME, this.headerName);
        }
        DOMUtils.addAttribute(element, NAMESPACE, this.namespaceUri);
        return element;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        if (objectInput.readBoolean()) {
            this.headerName = objectInput.readUTF();
        }
        this.namespaceUri = objectInput.readUTF();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        if (this.headerName != null && this.headerName.length() > 0) {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(this.headerName);
        } else {
            objectOutput.writeBoolean(false);
        }
        objectOutput.writeUTF(this.namespaceUri);
    }
}

