/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy12.assertions.RequestSecurityTokenTemplate;
import weblogic.wsee.security.policy12.assertions.RequireExternalReference;
import weblogic.wsee.security.policy12.assertions.Token;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class IssuedToken
extends Token {
    private static final long serialVersionUID = 7431269518604532400L;
    public static final String ISSUED_TOKEN = "IssuedToken";
    private RequestSecurityTokenTemplate template;
    private RequireExternalReference requireExternalReference = null;

    public QName getName() {
        return new QName(this.getNamespace(), ISSUED_TOKEN, "sp");
    }

    protected void init(Element element) throws PolicyException {
        super.init(element);
        try {
            Element element2;
            Element element3 = DOMUtils.getOptionalElementByTagNameNS(element, this.getNamespace(), "RequestSecurityTokenTemplate");
            if (element3 != null) {
                this.template = new RequestSecurityTokenTemplate();
                this.template.initialize(element3);
            }
            if ((element2 = DOMUtils.getOptionalElementByTagNameNS(element, this.getNamespace(), "RequireExternalReference")) != null) {
                this.requireExternalReference = new RequireExternalReference();
            }
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new PolicyException((Throwable)((Object)dOMProcessingException));
        }
    }

    public Element serialize(Document document) throws PolicyException {
        Element element = super.serialize(document);
        if (this.template != null) {
            this.template.serializeAssertion(document, element);
        }
        return element;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        if (objectInput.readBoolean()) {
            this.template = new RequestSecurityTokenTemplate();
            this.template.readExternal(objectInput);
        }
        if (objectInput.readBoolean()) {
            this.requireExternalReference = new RequireExternalReference();
            this.requireExternalReference.readExternal(objectInput);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        if (this.template != null) {
            objectOutput.writeBoolean(true);
            this.template.writeExternal(objectOutput);
        } else {
            objectOutput.writeBoolean(false);
        }
        if (this.requireExternalReference != null) {
            objectOutput.writeBoolean(true);
            this.requireExternalReference.writeExternal(objectOutput);
        } else {
            objectOutput.writeBoolean(false);
        }
    }

    public RequireExternalReference getRequireExternalReference() {
        if (this.requireExternalReference != null) {
            return this.requireExternalReference;
        }
        return (RequireExternalReference)this.getNestedAssertion(RequireExternalReference.class);
    }

    public RequestSecurityTokenTemplate getRequestSecurityTokenTemplate() {
        return this.template;
    }
}

