/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy12.assertions.Address;
import weblogic.wsee.security.policy12.assertions.SecurityPolicy12Assertion;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class Issuer
extends SecurityPolicy12Assertion {
    private static final long serialVersionUID = 3689353876029314719L;
    public static final String ISSUER = "Issuer";
    private Address address;
    private String uriText = null;

    public QName getName() {
        return new QName(this.getNamespace(), ISSUER, "sp");
    }

    public String getIssuerUri() {
        if (null != this.address) {
            return this.address.getEndpointAddress();
        }
        return this.uriText;
    }

    void initAssertion(Element element) throws PolicyException {
        this.setNamespace(element.getNamespaceURI());
        try {
            Element element2 = DOMUtils.getOptionalElementByTagNameNS(element, "http://www.w3.org/2005/08/addressing", "Address");
            if (element2 == null) {
                element2 = DOMUtils.getOptionalElementByTagNameNS(element, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address");
            }
            if (element2 != null) {
                this.address = new Address();
                this.address.initialize(element);
            } else if (element.hasChildNodes()) {
                this.uriText = element.getFirstChild().getNodeValue();
            }
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new PolicyException((Throwable)((Object)dOMProcessingException));
        }
    }

    Element serializeAssertion(Document document, Element element) throws PolicyException {
        if (null == this.address && this.uriText == null) {
            return element;
        }
        Element element2 = weblogic.wsee.policy.framework.DOMUtils.createElement(this.getName(), document, element.getPrefix());
        if (this.address != null) {
            Element element3 = this.address.serialize(document);
            element2.appendChild(element3);
        } else if (this.uriText != null) {
            DOMUtils.addTextData(element2, this.uriText);
        }
        element.appendChild(element2);
        return element;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof String) {
            this.uriText = (String)object;
        } else {
            this.address = new Address();
            this.address.readExternal(objectInput);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        if (this.address != null) {
            this.address.writeExternal(objectOutput);
        }
        if (this.uriText != null) {
            objectOutput.writeUTF(this.uriText);
        }
    }
}

