/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy12.assertions.SecurityPolicy12Assertion;
import weblogic.xml.dom.DOMUtils;

public class IssuerName
extends SecurityPolicy12Assertion {
    public static final String ISSUER_NAME = "IssuerName";
    private String issuerName = null;

    public QName getName() {
        return new QName(this.getNamespace(), ISSUER_NAME, "sp");
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    void initAssertion(Element element) throws PolicyException {
        this.issuerName = DOMUtils.getTextContent(element, true);
    }

    Element serializeAssertion(Document document, Element element) throws PolicyException {
        DOMUtils.addTextData(element, this.issuerName);
        return element;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.issuerName = objectInput.readUTF();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.issuerName);
    }
}

