/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.NestedPolicyAssertion;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyConstants;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.security.policy12.assertions.AbstractSecurityPolicyAssertion;
import weblogic.wsee.security.policy12.assertions.SecurityPolicy12AssertionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NestedSecurityPolicy12Assertion
extends NestedPolicyAssertion
implements AbstractSecurityPolicyAssertion {
    private String namespace;

    void setNamespace(String string) {
        this.namespace = string;
    }

    String getNamespace() {
        return this.namespace;
    }

    @Override
    public Set<PolicyAssertion> readNestedAssertion(Element element) throws PolicyException {
        LinkedHashSet<PolicyAssertion> linkedHashSet = new LinkedHashSet<PolicyAssertion>();
        PolicyAssertion policyAssertion = SecurityPolicy12AssertionFactory.getInstance().createAssertion(element);
        if (policyAssertion != null && NestedPolicyAssertion.class.isAssignableFrom(policyAssertion.getClass())) {
            NestedPolicyAssertion nestedPolicyAssertion = (NestedPolicyAssertion)policyAssertion;
            if (nestedPolicyAssertion.getNestedPolicy() != null && nestedPolicyAssertion.getNestedPolicy().getPolicyAlternatives() != null && nestedPolicyAssertion.getNestedPolicy().getPolicyAlternatives().size() > 1) {
                Iterator iterator = nestedPolicyAssertion.getNestedPolicy().getPolicyAlternatives().iterator();
                while (iterator.hasNext()) {
                    LinkedHashSet linkedHashSet2 = new LinkedHashSet();
                    linkedHashSet2.add(iterator.next());
                    NestedPolicyAssertion nestedPolicyAssertion2 = (NestedPolicyAssertion)nestedPolicyAssertion.clone();
                    nestedPolicyAssertion2.setNestedPolicy(NormalizedExpression.createFromPolicyAlternatives(linkedHashSet2));
                    linkedHashSet.add(nestedPolicyAssertion2);
                }
            } else {
                linkedHashSet.add(policyAssertion);
            }
        } else {
            linkedHashSet.add(policyAssertion);
        }
        return linkedHashSet;
    }

    @Override
    public Element serialize(Document document) throws PolicyException {
        Element element = DOMUtils.createElement(this.getName(), document, "sp");
        if (this.nestedPolicy != null && !this.nestedPolicy.isEmpty()) {
            Element element2 = "http://www.w3.org/ns/ws-policy".equals(this.nestedPolicy.getPolicyNamespaceUri()) || PolicyHelper.hasWsp15NamespaceUri(element) ? DOMUtils.createElement(PolicyConstants.POLICY_STATEMENT_ELEMENT_15, document, "wsp15") : DOMUtils.createElement(PolicyConstants.POLICY_STATEMENT_ELEMENT, document, "wsp");
            element.appendChild(element2);
            Set set = this.nestedPolicy.getPolicyAlternatives();
            if (set != null) {
                for (PolicyAlternative policyAlternative : set) {
                    if (policyAlternative == null || policyAlternative.isEmpty()) continue;
                    for (PolicyAssertion policyAssertion : policyAlternative.getAssertions()) {
                        if (policyAssertion == null) continue;
                        element2.appendChild(policyAssertion.serialize(document));
                    }
                }
            }
        }
        return element;
    }

    @Override
    public void initialize(Element element) throws PolicyException {
        this.setNamespace(element.getNamespaceURI());
        this.init(element);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.namespace = objectInput.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.namespace);
    }
}

