/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.security.policy12.assertions.Body;
import weblogic.wsee.security.policy12.assertions.Header;
import weblogic.wsee.security.policy12.assertions.SecurityPolicy12Assertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QNameParts
extends SecurityPolicy12Assertion {
    private static final long serialVersionUID = 8092996954978190735L;
    private Body body = null;
    private Set<Header> headers = new LinkedHashSet<Header>();
    private boolean bodyOptional = false;
    private List unknown = null;

    public Body getBody() {
        return this.body;
    }

    public Set<Header> getHeaders() {
        return this.headers;
    }

    public List getUnknown() {
        return this.unknown;
    }

    public boolean isBodyOptional() {
        return this.bodyOptional;
    }

    public void setBodyOptional(boolean bl) {
        this.bodyOptional = bl;
    }

    @Override
    void initAssertion(Element element) throws PolicyException {
        try {
            if (null == element) {
                throw new PolicyException("Null element");
            }
            this.unknown = new ArrayList();
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                Object object;
                if (!(node instanceof Element)) continue;
                Element element2 = (Element)node;
                if (this.getNamespace().equals(element2.getNamespaceURI()) && "Body".equals(element2.getLocalName())) {
                    this.body = new Body();
                    this.body.setNamespace(this.getNamespace());
                    object = PolicyHelper.getOptionalPolicyNamespaceUri(element2);
                    if (null == object) continue;
                    this.setPolicyNamespaceUri((String)object);
                    this.optional = true;
                    this.bodyOptional = true;
                    continue;
                }
                if (this.getNamespace().equals(element2.getNamespaceURI()) && "Header".equals(element2.getLocalName())) {
                    object = new Header();
                    ((SecurityPolicy12Assertion)object).initialize(element2);
                    this.headers.add((Header)object);
                    continue;
                }
                this.unknown.add(element2);
            }
            if (this.unknown.isEmpty()) {
                this.unknown = null;
            }
        }
        catch (Exception exception) {
            throw new PolicyException(exception);
        }
    }

    @Override
    Element serializeAssertion(Document document, Element element) throws PolicyException {
        if (this.body != null) {
            Element element2 = this.body.serialize(document);
            if (this.bodyOptional) {
                PolicyHelper.addOptionalAttribute(element2, this.getPolicyNamespaceUri());
            }
            element.appendChild(element2);
        }
        for (Header header : this.headers) {
            element.appendChild(header.serialize(document));
        }
        return element;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        if (objectInput.readBoolean()) {
            this.body = new Body();
        }
        this.headers = new LinkedHashSet<Header>();
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            Header header = new Header();
            header.readExternal(objectInput);
            this.headers.add(header);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeBoolean(this.body != null);
        objectOutput.writeInt(this.headers.size());
        for (Header header : this.headers) {
            header.writeExternal(objectOutput);
        }
    }
}

