/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.security.policy12.assertions.SecurityPolicy12Assertion;

public class RequestSecurityTokenTemplate
extends SecurityPolicy12Assertion {
    private static final long serialVersionUID = -3174843977306475189L;
    public static final String REQUET_SECURITY_TOKEN_TEMPLATE = "RequestSecurityTokenTemplate";
    Map templateMap = null;

    void initAssertion(Element element) throws PolicyException {
        if (null == element) {
            return;
        }
        String string = PolicyHelper.getOptionalPolicyNamespaceUri(element);
        if (string != null) {
            this.setPolicyNamespaceUri(string);
            this.setOptional(true);
        }
        this.templateMap = new HashMap();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            QName qName = new QName(element2.getNamespaceURI(), element2.getLocalName());
            String string2 = DOMUtils.getTextContent(element2, true);
            this.templateMap.put(qName, string2);
        }
    }

    Element serializeAssertion(Document document, Element element) throws PolicyException {
        if (this.templateMap == null || this.templateMap.size() == 0) {
            return element;
        }
        Element element2 = DOMUtils.createElement(this.getName(), document, element.getPrefix());
        Set set = this.templateMap.entrySet();
        for (Map.Entry entry : set) {
            Element element3 = DOMUtils.createElement((QName)entry.getKey(), document);
            element3.appendChild(document.createTextNode((String)entry.getValue()));
            element2.appendChild(element3);
        }
        element.appendChild(element2);
        return element;
    }

    public QName getName() {
        return new QName(this.getNamespace(), REQUET_SECURITY_TOKEN_TEMPLATE, "sp");
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.templateMap = new HashMap();
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = (Map.Entry)objectInput.readObject();
            this.templateMap.put(entry.getKey(), entry.getValue());
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.templateMap.size());
        Set set = this.templateMap.entrySet();
        for (Map.Entry entry : set) {
            objectOutput.writeObject(entry);
        }
    }

    public Map getTemplateMap() {
        return this.templateMap;
    }
}

