/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy12.assertions.BootstrapPolicy;
import weblogic.wsee.security.policy12.assertions.RequireExternalUriReference;
import weblogic.wsee.security.policy12.assertions.SC200502SecurityContextToken;
import weblogic.wsee.security.policy12.assertions.Token;

public class SecureConversationToken
extends Token {
    public static final String SECURE_CONVERSATION_TOKEN = "SecureConversationToken";

    protected void init(Element element) throws PolicyException {
        super.init(element);
    }

    public Element serialize(Document document) throws PolicyException {
        Element element = super.serialize(document);
        if (this.issuer != null) {
            return this.issuer.serialize(document);
        }
        return element;
    }

    public QName getName() {
        return new QName(this.getNamespace(), SECURE_CONVERSATION_TOKEN, "sp");
    }

    public boolean isSC200502SecurityContextToken() {
        return (SC200502SecurityContextToken)this.getNestedAssertion(SC200502SecurityContextToken.class) != null;
    }

    public boolean isSC13SecurityContextToken() {
        return (SC200502SecurityContextToken)this.getNestedAssertion(SC200502SecurityContextToken.class) == null;
    }

    public RequireExternalUriReference getRequireExternalUriReference() {
        return (RequireExternalUriReference)this.getNestedAssertion(RequireExternalUriReference.class);
    }

    public BootstrapPolicy getBootstrapPolicy() {
        return (BootstrapPolicy)this.getNestedAssertion(BootstrapPolicy.class);
    }

    public NormalizedExpression getNormalizedBootstrapPolicy() {
        BootstrapPolicy bootstrapPolicy = this.getBootstrapPolicy();
        if (bootstrapPolicy != null) {
            return bootstrapPolicy.getNestedPolicy();
        }
        return null;
    }
}

