/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.security.policy12.assertions.AbstractSecurityPolicyAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SecurityPolicy12Assertion
extends PolicyAssertion
implements AbstractSecurityPolicyAssertion {
    private String namespace;
    private Map<String, String> elementAttrs;

    void setNamespace(String string) {
        this.namespace = string;
    }

    String getNamespace() {
        return this.namespace;
    }

    public Map<String, String> getElementAttrs() {
        return this.elementAttrs;
    }

    @Override
    public void initialize(Element element) throws PolicyException {
        this.setNamespace(element.getNamespaceURI());
        this.elementAttrs = DOMUtils.getAttributeMap(element);
        this.initAssertion(element);
    }

    abstract void initAssertion(Element var1) throws PolicyException;

    abstract Element serializeAssertion(Document var1, Element var2) throws PolicyException;

    @Override
    public Element serialize(Document document) throws PolicyException {
        Element element = DOMUtils.createElement(this.getName(), document, "sp");
        if (this.optional) {
            PolicyHelper.addOptionalAttribute(element, this.getPolicyNamespaceUri());
        }
        return this.serializeAssertion(document, element);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.namespace = objectInput.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.namespace);
    }
}

