/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.policy.framework.ExternalizationUtils;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyAssertionFactory;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy12.assertions.AbstractSecurityPolicyAssertion;
import weblogic.wsee.security.policy12.assertions.AlgorithmSuite;
import weblogic.wsee.security.policy12.assertions.AsymmetricBinding;
import weblogic.wsee.security.policy12.assertions.Basic128;
import weblogic.wsee.security.policy12.assertions.Basic128Rsa15;
import weblogic.wsee.security.policy12.assertions.Basic128Sha256;
import weblogic.wsee.security.policy12.assertions.Basic128Sha256Rsa15;
import weblogic.wsee.security.policy12.assertions.Basic192;
import weblogic.wsee.security.policy12.assertions.Basic192Rsa15;
import weblogic.wsee.security.policy12.assertions.Basic192Sha256;
import weblogic.wsee.security.policy12.assertions.Basic192Sha256Rsa15;
import weblogic.wsee.security.policy12.assertions.Basic256;
import weblogic.wsee.security.policy12.assertions.Basic256Rsa15;
import weblogic.wsee.security.policy12.assertions.Basic256Sha256;
import weblogic.wsee.security.policy12.assertions.Basic256Sha256Rsa15;
import weblogic.wsee.security.policy12.assertions.Body;
import weblogic.wsee.security.policy12.assertions.BootstrapPolicy;
import weblogic.wsee.security.policy12.assertions.ContentEncryptedElements;
import weblogic.wsee.security.policy12.assertions.Created;
import weblogic.wsee.security.policy12.assertions.EncryptBeforeSigning;
import weblogic.wsee.security.policy12.assertions.EncryptSignature;
import weblogic.wsee.security.policy12.assertions.EncryptedElements;
import weblogic.wsee.security.policy12.assertions.EncryptedParts;
import weblogic.wsee.security.policy12.assertions.EncryptedSupportingTokens;
import weblogic.wsee.security.policy12.assertions.EncryptionToken;
import weblogic.wsee.security.policy12.assertions.EndorsingSupportingTokens;
import weblogic.wsee.security.policy12.assertions.HashPassword;
import weblogic.wsee.security.policy12.assertions.Header;
import weblogic.wsee.security.policy12.assertions.HttpBasicAuthentication;
import weblogic.wsee.security.policy12.assertions.HttpsToken;
import weblogic.wsee.security.policy12.assertions.IncludeTimestamp;
import weblogic.wsee.security.policy12.assertions.InitiatorEncryptionToken;
import weblogic.wsee.security.policy12.assertions.InitiatorSignatureToken;
import weblogic.wsee.security.policy12.assertions.InitiatorToken;
import weblogic.wsee.security.policy12.assertions.IssuedToken;
import weblogic.wsee.security.policy12.assertions.Issuer;
import weblogic.wsee.security.policy12.assertions.IssuerName;
import weblogic.wsee.security.policy12.assertions.KerberosToken;
import weblogic.wsee.security.policy12.assertions.Lax;
import weblogic.wsee.security.policy12.assertions.LaxTsFirst;
import weblogic.wsee.security.policy12.assertions.LaxTsLast;
import weblogic.wsee.security.policy12.assertions.Layout;
import weblogic.wsee.security.policy12.assertions.MustSupportClientChallenge;
import weblogic.wsee.security.policy12.assertions.MustSupportIssuedTokens;
import weblogic.wsee.security.policy12.assertions.MustSupportRefEmbeddedToken;
import weblogic.wsee.security.policy12.assertions.MustSupportRefEncryptedKey;
import weblogic.wsee.security.policy12.assertions.MustSupportRefExternalURI;
import weblogic.wsee.security.policy12.assertions.MustSupportRefIssuerSerial;
import weblogic.wsee.security.policy12.assertions.MustSupportRefKeyIdentifier;
import weblogic.wsee.security.policy12.assertions.MustSupportRefThumbprint;
import weblogic.wsee.security.policy12.assertions.MustSupportServerChallenge;
import weblogic.wsee.security.policy12.assertions.NoPassword;
import weblogic.wsee.security.policy12.assertions.Nonce;
import weblogic.wsee.security.policy12.assertions.OnlySignEntireHeadersAndBody;
import weblogic.wsee.security.policy12.assertions.ProtectTokens;
import weblogic.wsee.security.policy12.assertions.ProtectionToken;
import weblogic.wsee.security.policy12.assertions.RecipientEncryptionToken;
import weblogic.wsee.security.policy12.assertions.RecipientSignatureToken;
import weblogic.wsee.security.policy12.assertions.RecipientToken;
import weblogic.wsee.security.policy12.assertions.RelToken;
import weblogic.wsee.security.policy12.assertions.RequireClientCertificate;
import weblogic.wsee.security.policy12.assertions.RequireClientEntropy;
import weblogic.wsee.security.policy12.assertions.RequireDerivedKeys;
import weblogic.wsee.security.policy12.assertions.RequireEmbeddedTokenReference;
import weblogic.wsee.security.policy12.assertions.RequireExplicitDerivedKeys;
import weblogic.wsee.security.policy12.assertions.RequireExternalReference;
import weblogic.wsee.security.policy12.assertions.RequireExternalUriReference;
import weblogic.wsee.security.policy12.assertions.RequireImplicitDerivedKeys;
import weblogic.wsee.security.policy12.assertions.RequireInternalReference;
import weblogic.wsee.security.policy12.assertions.RequireIssuerSerialReference;
import weblogic.wsee.security.policy12.assertions.RequireKeyIdentifierReference;
import weblogic.wsee.security.policy12.assertions.RequireServerEntropy;
import weblogic.wsee.security.policy12.assertions.RequireSignatureConfirmation;
import weblogic.wsee.security.policy12.assertions.RequireThumbprintReference;
import weblogic.wsee.security.policy12.assertions.RequiredElements;
import weblogic.wsee.security.policy12.assertions.RequiredParts;
import weblogic.wsee.security.policy12.assertions.SC200502SecurityContextToken;
import weblogic.wsee.security.policy12.assertions.SamlToken;
import weblogic.wsee.security.policy12.assertions.SecureConversationToken;
import weblogic.wsee.security.policy12.assertions.SignatureToken;
import weblogic.wsee.security.policy12.assertions.SignedElements;
import weblogic.wsee.security.policy12.assertions.SignedEncryptedSupportingTokens;
import weblogic.wsee.security.policy12.assertions.SignedEndorsingSupportingTokens;
import weblogic.wsee.security.policy12.assertions.SignedParts;
import weblogic.wsee.security.policy12.assertions.SignedSupportingTokens;
import weblogic.wsee.security.policy12.assertions.Strict;
import weblogic.wsee.security.policy12.assertions.SupportingTokens;
import weblogic.wsee.security.policy12.assertions.SymmetricBinding;
import weblogic.wsee.security.policy12.assertions.TransportBinding;
import weblogic.wsee.security.policy12.assertions.TransportToken;
import weblogic.wsee.security.policy12.assertions.TripleDes;
import weblogic.wsee.security.policy12.assertions.TripleDesRsa15;
import weblogic.wsee.security.policy12.assertions.TripleDesSha256;
import weblogic.wsee.security.policy12.assertions.TripleDesSha256Rsa15;
import weblogic.wsee.security.policy12.assertions.Trust10;
import weblogic.wsee.security.policy12.assertions.UsernameToken;
import weblogic.wsee.security.policy12.assertions.Wss10;
import weblogic.wsee.security.policy12.assertions.Wss11;
import weblogic.wsee.security.policy12.assertions.WssGssKerberosV5ApReqToken11;
import weblogic.wsee.security.policy12.assertions.WssKerberosV5ApReqToken11;
import weblogic.wsee.security.policy12.assertions.WssRelV10Token10;
import weblogic.wsee.security.policy12.assertions.WssRelV10Token11;
import weblogic.wsee.security.policy12.assertions.WssRelV20Token10;
import weblogic.wsee.security.policy12.assertions.WssRelV20Token11;
import weblogic.wsee.security.policy12.assertions.WssSamlV11Token10;
import weblogic.wsee.security.policy12.assertions.WssSamlV11Token11;
import weblogic.wsee.security.policy12.assertions.WssSamlV20Token11;
import weblogic.wsee.security.policy12.assertions.WssUsernameToken10;
import weblogic.wsee.security.policy12.assertions.WssUsernameToken11;
import weblogic.wsee.security.policy12.assertions.WssX509Pkcs7Token10;
import weblogic.wsee.security.policy12.assertions.WssX509Pkcs7Token11;
import weblogic.wsee.security.policy12.assertions.WssX509PkiPathV1Token10;
import weblogic.wsee.security.policy12.assertions.WssX509PkiPathV1Token11;
import weblogic.wsee.security.policy12.assertions.WssX509V1Token11;
import weblogic.wsee.security.policy12.assertions.WssX509V3Token10;
import weblogic.wsee.security.policy12.assertions.WssX509V3Token11;
import weblogic.wsee.security.policy12.assertions.X509Token;
import weblogic.wsee.security.policy12.assertions.XPath;
import weblogic.wsee.util.Verbose;

public class SecurityPolicy12AssertionFactory
extends PolicyAssertionFactory {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicy12AssertionFactory.class);
    private static final SecurityPolicy12AssertionFactory theOne = new SecurityPolicy12AssertionFactory();

    public static SecurityPolicy12AssertionFactory getInstance() {
        return theOne;
    }

    public PolicyAssertion createAssertion(Node node) throws PolicyException {
        String string;
        String string2 = node.getNamespaceURI();
        if (string2 != null && (string2.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702") || string2.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512") || string2.equals("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy") || string2.equals("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200802")) && (string = ExternalizationUtils.getClassNameFromMap(new QName(node.getNamespaceURI(), node.getLocalName()))) != null) {
            try {
                PolicyAssertion policyAssertion = (PolicyAssertion)Class.forName(string).newInstance();
                if (policyAssertion instanceof AbstractSecurityPolicyAssertion) {
                    ((AbstractSecurityPolicyAssertion)((Object)policyAssertion)).initialize((Element)node);
                }
                return policyAssertion;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final void init() {
        if (verbose) {
            Verbose.log("In SecurityPolicy12AssertionFactory, registering WS-SP 1.2 assertions in namespace: http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512");
        }
        SecurityPolicy12AssertionFactory.registerAssertions("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512");
    }

    protected static final void registerAssertions(String string) {
        ExternalizationUtils.registerExternalizable(new QName(string, "TransportBinding", "sp"), TransportBinding.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "TransportToken", "sp"), TransportToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "HttpsToken", "sp"), HttpsToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "HttpBasicAuthentication", "sp"), HttpBasicAuthentication.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireClientCertificate", "sp"), RequireClientCertificate.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "AlgorithmSuite", "sp"), AlgorithmSuite.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Basic256", "sp"), Basic256.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "TripleDes", "sp"), TripleDes.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Basic192", "sp"), Basic192.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Basic128", "sp"), Basic128.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Basic256Rsa15", "sp"), Basic256Rsa15.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Basic128Rsa15", "sp"), Basic128Rsa15.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Basic192Rsa15", "sp"), Basic192Rsa15.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "TripleDesRsa15", "sp"), TripleDesRsa15.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Basic256Sha256", "sp"), Basic256Sha256.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "TripleDesSha256", "sp"), TripleDesSha256.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Basic192Sha256", "sp"), Basic192Sha256.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Basic128Sha256", "sp"), Basic128Sha256.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Basic256Sha256Rsa15", "sp"), Basic256Sha256Rsa15.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "TripleDesSha256Rsa15", "sp"), TripleDesSha256Rsa15.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Basic192Sha256Rsa15", "sp"), Basic192Sha256Rsa15.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Basic128Sha256Rsa15", "sp"), Basic128Sha256Rsa15.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Layout", "sp"), Layout.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Lax", "sp"), Lax.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Strict", "sp"), Strict.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "LaxTsFirst", "sp"), LaxTsFirst.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "LaxTsLast", "sp"), LaxTsLast.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "IncludeTimestamp", "sp"), IncludeTimestamp.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "UsernameToken", "sp"), UsernameToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssUsernameToken10", "sp"), WssUsernameToken10.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssUsernameToken11", "sp"), WssUsernameToken11.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "HashPassword", "sp"), HashPassword.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "NoPassword", "sp"), NoPassword.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireDerivedKeys", "sp"), RequireDerivedKeys.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireImplicitDerivedKeys", "sp"), RequireImplicitDerivedKeys.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireExplicitDerivedKeys", "sp"), RequireExplicitDerivedKeys.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "SecureConversationToken", "sp"), SecureConversationToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "BootstrapPolicy", "sp"), BootstrapPolicy.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireExternalUriReference", "sp"), RequireExternalUriReference.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "SC200502SecurityContextToken", "sp"), SC200502SecurityContextToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "EncryptBeforeSigning", "sp"), EncryptBeforeSigning.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "EncryptSignature", "sp"), EncryptSignature.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "ProtectTokens", "sp"), ProtectTokens.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "OnlySignEntireHeadersAndBody", "sp"), OnlySignEntireHeadersAndBody.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "SymmetricBinding", "sp"), SymmetricBinding.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "AsymmetricBinding", "sp"), AsymmetricBinding.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "ProtectionToken", "sp"), ProtectionToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "EncryptionToken", "sp"), EncryptionToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "SignatureToken", "sp"), SignatureToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Issuer", "sp"), Issuer.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "IssuerName", "sp"), IssuerName.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "IssuedToken", "sp"), IssuedToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Trust10", "sp"), Trust10.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "MustSupportClientChallenge", "sp"), MustSupportClientChallenge.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "MustSupportServerChallenge", "sp"), MustSupportServerChallenge.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireClientEntropy", "sp"), RequireClientEntropy.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireServerEntropy", "sp"), RequireServerEntropy.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "MustSupportIssuedTokens", "sp"), MustSupportIssuedTokens.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "SupportingTokens", "sp"), SupportingTokens.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "SignedSupportingTokens", "sp"), SignedSupportingTokens.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "EncryptedSupportingTokens", "sp"), EncryptedSupportingTokens.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "SignedEncryptedSupportingTokens", "sp"), SignedEncryptedSupportingTokens.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "EndorsingSupportingTokens", "sp"), EndorsingSupportingTokens.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "SignedEndorsingSupportingTokens", "sp"), SignedEndorsingSupportingTokens.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "InitiatorToken", "sp"), InitiatorToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "InitiatorSignatureToken", "sp"), InitiatorSignatureToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "InitiatorEncryptionToken", "sp"), InitiatorEncryptionToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RecipientToken", "sp"), RecipientToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RecipientSignatureToken", "sp"), RecipientSignatureToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RecipientEncryptionToken", "sp"), RecipientEncryptionToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "X509Token", "sp"), X509Token.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireKeyIdentifierReference", "sp"), RequireKeyIdentifierReference.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireIssuerSerialReference", "sp"), RequireIssuerSerialReference.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireEmbeddedTokenReference", "sp"), RequireEmbeddedTokenReference.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireThumbprintReference", "sp"), RequireThumbprintReference.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssX509V3Token10", "sp"), WssX509V3Token10.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssX509Pkcs7Token10", "sp"), WssX509Pkcs7Token10.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssX509PkiPathV1Token10", "sp"), WssX509PkiPathV1Token10.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssX509V1Token11", "sp"), WssX509V1Token11.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssX509V3Token11", "sp"), WssX509V3Token11.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssX509Pkcs7Token11", "sp"), WssX509Pkcs7Token11.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssX509PkiPathV1Token11", "sp"), WssX509PkiPathV1Token11.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Body", "sp"), Body.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Header", "sp"), Header.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "SignedParts", "sp"), SignedParts.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "EncryptedParts", "sp"), EncryptedParts.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequiredParts", "sp"), RequiredParts.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "XPath", "sp"), XPath.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "SignedElements", "sp"), SignedElements.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "EncryptedElements", "sp"), EncryptedElements.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "ContentEncryptedElements", "sp"), ContentEncryptedElements.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequiredElements", "sp"), RequiredElements.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Wss10", "sp"), Wss10.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Wss11", "sp"), Wss11.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "MustSupportRefKeyIdentifier", "sp"), MustSupportRefKeyIdentifier.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "MustSupportRefIssuerSerial", "sp"), MustSupportRefIssuerSerial.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "MustSupportRefExternalURI", "sp"), MustSupportRefExternalURI.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "MustSupportRefEmbeddedToken", "sp"), MustSupportRefEmbeddedToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "MustSupportRefThumbprint", "sp"), MustSupportRefThumbprint.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "MustSupportRefEncryptedKey", "sp"), MustSupportRefEncryptedKey.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireSignatureConfirmation", "sp"), RequireSignatureConfirmation.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "KerberosToken", "sp"), KerberosToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssKerberosV5ApReqToken11", "sp"), WssKerberosV5ApReqToken11.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssGssKerberosV5ApReqToken11", "sp"), WssGssKerberosV5ApReqToken11.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RelToken", "sp"), RelToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssRelV10Token10", "sp"), WssRelV10Token10.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssRelV20Token10", "sp"), WssRelV20Token10.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssRelV10Token11", "sp"), WssRelV10Token11.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssRelV20Token11", "sp"), WssRelV20Token11.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "SamlToken", "sp"), SamlToken.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssSamlV11Token10", "sp"), WssSamlV11Token10.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssSamlV11Token11", "sp"), WssSamlV11Token11.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "WssSamlV20Token11", "sp"), WssSamlV20Token11.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireInternalReference", "sp"), RequireInternalReference.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "RequireExternalReference", "sp"), RequireExternalReference.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Nonce", "sp"), Nonce.class.getName());
        ExternalizationUtils.registerExternalizable(new QName(string, "Created", "sp"), Created.class.getName());
    }

    static {
        SecurityPolicy12AssertionFactory.init();
    }
}

