/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.security.policy12.assertions.Issuer;
import weblogic.wsee.security.policy12.assertions.IssuerName;
import weblogic.wsee.security.policy12.assertions.NestedSecurityPolicy12Assertion;
import weblogic.wsee.security.policy12.assertions.RequireDerivedKeys;
import weblogic.wsee.security.policy12.assertions.RequireExplicitDerivedKeys;
import weblogic.wsee.security.policy12.assertions.RequireExternalReference;
import weblogic.wsee.security.policy12.assertions.RequireImplicitDerivedKeys;
import weblogic.wsee.security.policy12.assertions.RequireInternalReference;
import weblogic.xml.dom.DOMUtils;

public abstract class Token
extends NestedSecurityPolicy12Assertion {
    private static final long serialVersionUID = -4920883495980897630L;
    public static final String ISSUER = "Issuer";
    TokenInclusion tokenInclusion = null;
    protected Issuer issuer = null;
    protected String isserName = null;

    protected void init(Element element) throws PolicyException {
        super.init(element);
        String string = weblogic.wsee.policy.framework.DOMUtils.getAttributeValueAsString(element, new QName(this.getNamespace(), "IncludeToken", "sp"));
        if (string != null && string.length() > 0) {
            this.tokenInclusion = new TokenInclusion(string);
            this.tokenInclusion.setNamespace(element.getNamespaceURI());
        }
        try {
            String string2;
            Object object;
            this.issuer = (Issuer)this.getNestedAssertion(Issuer.class);
            if (null == this.issuer) {
                object = DOMUtils.getOptionalElementByTagNameNS(element, "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", ISSUER);
                if (object == null) {
                    object = DOMUtils.getOptionalElementByTagNameNS(element, "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512", ISSUER);
                }
                if (null != object) {
                    this.issuer = new Issuer();
                    this.issuer.initAssertion((Element)object);
                }
            }
            if ((object = (IssuerName)this.getNestedAssertion(IssuerName.class)) != null) {
                this.isserName = ((IssuerName)object).getIssuerName();
            }
            if (null != (string2 = PolicyHelper.getOptionalPolicyNamespaceUri(element))) {
                this.setPolicyNamespaceUri(string2);
                this.setOptional(true);
            }
        }
        catch (Exception exception) {
            throw new PolicyException(exception);
        }
    }

    public Element serialize(Document document) throws PolicyException {
        Element element = super.serialize(document);
        if (this.tokenInclusion != null) {
            this.tokenInclusion.serialize(element);
        }
        if (this.issuer != null) {
            this.issuer.serializeAssertion(document, element);
        }
        return element;
    }

    public RequireDerivedKeys getRequireDerivedKeys() {
        return (RequireDerivedKeys)this.getNestedAssertion(RequireDerivedKeys.class);
    }

    public RequireImplicitDerivedKeys getRequireImplicitDerivedKeys() {
        return (RequireImplicitDerivedKeys)this.getNestedAssertion(RequireImplicitDerivedKeys.class);
    }

    public RequireExplicitDerivedKeys getRequireExplicitDerivedKeys() {
        return (RequireExplicitDerivedKeys)this.getNestedAssertion(RequireExplicitDerivedKeys.class);
    }

    public RequireInternalReference getRequireInternalReference() {
        return (RequireInternalReference)this.getNestedAssertion(RequireInternalReference.class);
    }

    public RequireExternalReference getRequireExternalReference() {
        return (RequireExternalReference)this.getNestedAssertion(RequireExternalReference.class);
    }

    public String getIssuer() {
        return this.issuer == null ? null : this.issuer.getIssuerUri();
    }

    public String getIssuerAddress() {
        if (this.issuer == null) {
            return null;
        }
        return this.issuer.getIssuerUri();
    }

    public String getIssuerName() {
        return this.isserName;
    }

    public TokenInclusion getTokenInclusion() {
        return this.tokenInclusion;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        if (objectInput.readBoolean()) {
            this.tokenInclusion = new TokenInclusion();
            this.tokenInclusion.readExternal(objectInput);
        }
        if (objectInput.readBoolean()) {
            this.issuer = new Issuer();
            this.issuer.readExternal(objectInput);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        if (this.tokenInclusion != null) {
            objectOutput.writeBoolean(true);
            this.tokenInclusion.writeExternal(objectOutput);
        } else {
            objectOutput.writeBoolean(false);
        }
        if (this.issuer != null) {
            objectOutput.writeBoolean(true);
            this.issuer.writeExternal(objectOutput);
        } else {
            objectOutput.writeBoolean(false);
        }
    }

    public static class TokenInclusion
    extends PolicyAssertion {
        public static final String TOKEN_INCLUSION = "IncludeToken";
        public static final String NEVER = "/IncludeToken/Never";
        public static final String ONCE = "/IncludeToken/Once";
        public static final String ALWAYS_TO_RECIPIENT = "/IncludeToken/AlwaysToRecipient";
        public static final String ALWAYS_TO_INITIATOR = "/IncludeToken/AlwaysToInitiator";
        public static final String ALWAYS = "/IncludeToken/Always";
        public static final String ALWAYS_TO_RECIPIENT2 = "/AlwaysToRecipient";
        private String inclusion = null;
        private String namespace;

        public TokenInclusion() {
        }

        public TokenInclusion(String string) {
            this.inclusion = string;
        }

        void setNamespace(String string) {
            this.namespace = string;
        }

        String getNamespace() {
            return this.namespace;
        }

        public QName getName() {
            return new QName(this.getNamespace(), TOKEN_INCLUSION, "sp");
        }

        public String getInclusion() {
            if (this.inclusion == null) {
                this.inclusion = this.getNamespace() + ALWAYS;
            }
            return this.inclusion;
        }

        public Element serialize(Document document) throws PolicyException {
            return null;
        }

        public void serialize(Element element) {
            weblogic.wsee.policy.framework.DOMUtils.addPrefixedAttribute(element, this.getName(), "sp", this.inclusion);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.inclusion = objectInput.readUTF();
            this.namespace = objectInput.readUTF();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.getInclusion());
            objectOutput.writeUTF(this.namespace);
        }
    }
}

