/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.security.policy12.assertions.SecurityPolicy12Assertion;
import weblogic.wsee.util.Verbose;
import weblogic.xml.dom.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPath
extends SecurityPolicy12Assertion {
    private static final long serialVersionUID = 6198433936359349042L;
    private static boolean verbose = Verbose.isVerbose(XPath.class);
    public static final String XPATH = "XPath";
    String xpathExpr;
    Map<String, String> xpathNamespaces = new HashMap<String, String>();
    private Element xpathNode;
    private String xpathVersion;
    private String assertionType;

    public String getXPathExpr() {
        return this.xpathExpr;
    }

    private void setXPathExpr(String string) {
        this.xpathExpr = string;
        if (!string.startsWith("/") && string.indexOf("::") < 0 && Pattern.matches("[a-zA-Z]", string.substring(0, 1))) {
            Iterator<Map.Entry<String, String>> iterator = this.xpathNamespaces.entrySet().iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                if (!entry.getValue().equals("http://schemas.xmlsoap.org/soap/envelope/") && !entry.getValue().equals("http://www.w3.org/2003/05/soap-envelope")) continue;
                string2 = entry.getKey();
                break;
            }
            if (string2 == null) {
                string2 = "soapenv";
                this.xpathNamespaces.put(string2, "http://schemas.xmlsoap.org/soap/envelope/");
                this.getElementAttrs().put("xmlns:" + string2, "http://schemas.xmlsoap.org/soap/envelope/");
            }
            this.xpathExpr = this.assertionType.equals("RequiredElements") ? "/" + string2 + ":Envelope/" + string2 + ":Header/" + string : "/" + string2 + ":Envelope/" + string;
            if (verbose) {
                Verbose.log("Converting relative XPath expression to absolute: " + this.xpathExpr);
            }
        }
    }

    public Map<String, String> getXPathNamespaces() {
        return this.xpathNamespaces;
    }

    public String getXPathVersion() {
        return this.xpathVersion;
    }

    public void setXPathVersion(String string) {
        this.xpathVersion = string;
    }

    public boolean getEncryptContentOnly() {
        return this.assertionType.equals("ContentEncryptedElements");
    }

    @Override
    public QName getName() {
        return new QName(this.getNamespace(), XPATH, "sp");
    }

    public void setAssertion(String string, String string2, String string3) {
        this.xpathVersion = string;
        this.assertionType = string3;
        this.setXPathExpr(string2);
    }

    @Override
    void initAssertion(Element element) {
        this.xpathNode = element;
        this.xpathNamespaces = weblogic.wsee.policy.framework.DOMUtils.getNamespaceMapping(this.xpathNode);
        this.assertionType = element.getParentNode().getLocalName();
        this.setXPathExpr(weblogic.wsee.policy.framework.DOMUtils.getTextContent(element, true));
    }

    @Override
    Element serializeAssertion(Document document, Element element) {
        DOMUtils.addTextData(element, this.xpathExpr);
        for (Map.Entry<String, String> entry : this.getElementAttrs().entrySet()) {
            element.setAttribute(entry.getKey(), entry.getValue());
        }
        return element;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.xpathExpr = objectInput.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.xpathExpr);
    }
}

