/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.assertions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.security.policy12.assertions.SecurityPolicy12Assertion;
import weblogic.wsee.security.policy12.assertions.XPath;
import weblogic.wsee.security.policy12.assertions.XPath2;
import weblogic.xml.dom.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XPathElements
extends SecurityPolicy12Assertion {
    private static final long serialVersionUID = 2407340005141782846L;
    private static final QName XPATH_VERSION = new QName("XPathVersion");
    private Set<XPath> xpathExprs = new LinkedHashSet<XPath>();
    private String xpathVersion;

    public Set<XPath> getXPathExpressions() {
        return this.xpathExprs;
    }

    public String getXPathVersion() {
        return this.xpathVersion;
    }

    public abstract boolean isRequired();

    @Override
    void initAssertion(Element element) throws PolicyException {
        XPath xPath;
        String string = PolicyHelper.getOptionalPolicyNamespaceUri(element);
        if (null != string) {
            this.setPolicyNamespaceUri(string);
            this.setOptional(true);
        }
        List list = DOMUtils.getOptionalElementsByTagNameNS(element, this.getNamespace(), "XPath");
        List list2 = DOMUtils.getOptionalElementsByTagNameNS(element, this.getNamespace(), "XPath2");
        this.xpathVersion = weblogic.wsee.policy.framework.DOMUtils.getAttributeValueAsString(element, XPATH_VERSION);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            xPath = new XPath();
            xPath.initialize((Element)iterator.next());
            xPath.setXPathVersion(this.xpathVersion);
            this.xpathExprs.add(xPath);
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            xPath = new XPath2();
            xPath.initialize((Element)iterator.next());
            xPath.setXPathVersion(this.xpathVersion);
            this.xpathExprs.add(xPath);
        }
    }

    @Override
    Element serializeAssertion(Document document, Element element) throws PolicyException {
        for (XPath object : this.xpathExprs) {
            element.appendChild(object.serialize(document));
        }
        for (Map.Entry entry : this.getElementAttrs().entrySet()) {
            boolean bl = true;
            if (((String)entry.getKey()).startsWith("xmlns")) {
                String string = ((String)entry.getKey()).substring(6);
                boolean bl2 = bl = !element.getNodeName().equals(string + ":" + element.getLocalName());
            }
            if (!bl) continue;
            element.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        return element;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.xpathVersion = objectInput.readUTF();
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            XPath xPath = objectInput.readBoolean() ? new XPath2() : new XPath();
            xPath.readExternal(objectInput);
            this.xpathExprs.add(xPath);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.xpathVersion);
        objectOutput.writeInt(this.xpathExprs.size());
        for (XPath xPath : this.xpathExprs) {
            objectOutput.writeBoolean(xPath instanceof XPath2);
            xPath.writeExternal(objectOutput);
        }
    }
}

