/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.wsee.security.policy12.assertions.ContentEncryptedElements;
import weblogic.wsee.security.policy12.assertions.EncryptedElements;
import weblogic.wsee.security.policy12.assertions.EncryptedParts;
import weblogic.wsee.security.policy12.assertions.Header;
import weblogic.wsee.security.policy12.assertions.XPath;
import weblogic.wsee.security.policy12.internal.QNameExprImpl;
import weblogic.wsee.security.wssp.ConfidentialityAssertion;
import weblogic.wsee.security.wssp.QNameExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfidentialityAssertionImpl
implements ConfidentialityAssertion {
    private boolean isEncryptedBodyRequired = false;
    private boolean isEncryptedBodyOptional = false;
    private boolean isEncryptedHeaderRequired = false;
    private List<String> encryptingElements = new ArrayList<String>();
    private List<String> contentEncryptingElements = new ArrayList<String>();
    private List<QNameExpr> encryptingParts = new ArrayList<QNameExpr>();
    private EncryptedElements encryptedElementsPolicy;
    private ContentEncryptedElements contentEncryptedElementsPolicy;
    private String xpathVersion;

    void init(ContentEncryptedElements contentEncryptedElements) {
        this.contentEncryptedElementsPolicy = contentEncryptedElements;
        String string = contentEncryptedElements.getXPathVersion();
        if (string != null && string.length() > 0) {
            this.xpathVersion = string;
        }
        Iterator<XPath> iterator = contentEncryptedElements.getXPathExpressions().iterator();
        while (iterator.hasNext()) {
            this.contentEncryptingElements.add(iterator.next().getXPathExpr());
        }
    }

    void init(EncryptedElements encryptedElements) {
        this.encryptedElementsPolicy = encryptedElements;
        String string = encryptedElements.getXPathVersion();
        if (string != null && string.length() > 0) {
            this.xpathVersion = string;
        }
        Iterator<XPath> iterator = encryptedElements.getXPathExpressions().iterator();
        while (iterator.hasNext()) {
            this.encryptingElements.add(iterator.next().getXPathExpr());
        }
    }

    void init(EncryptedParts encryptedParts) {
        if (encryptedParts.getBody() != null) {
            this.isEncryptedBodyRequired = true;
            this.isEncryptedBodyOptional = encryptedParts.isBodyOptional() || encryptedParts.getBody().isOptional() || encryptedParts.isOptional();
        }
        for (Header header : encryptedParts.getHeaders()) {
            this.encryptingParts.add(new QNameExprImpl(header.getHeaderName(), header.getHeaderNamespaceUri(), header.isOptional() || encryptedParts.isOptional()));
        }
    }

    @Override
    public boolean isEncryptedBodyRequired() {
        return this.isEncryptedBodyRequired;
    }

    @Override
    public boolean isEncryptedHeaderRequired() {
        return this.isEncryptedHeaderRequired;
    }

    @Override
    public boolean isEncryptedBodyOptional() {
        return this.isEncryptedBodyOptional;
    }

    void setEncryptedHeaderRequired(boolean bl) {
        this.isEncryptedHeaderRequired = bl;
    }

    @Override
    public List<String> getEncryptingElements() {
        return this.encryptingElements;
    }

    public List<String> getContentEncryptingElements() {
        return this.contentEncryptingElements;
    }

    @Override
    public EncryptedElements getEncryptedElementsPolicy() {
        return this.encryptedElementsPolicy;
    }

    @Override
    public ContentEncryptedElements getContentEncryptedElementsPolicy() {
        return this.contentEncryptedElementsPolicy;
    }

    @Override
    public String getXPathVersion() {
        return this.xpathVersion;
    }

    @Override
    public List<QNameExpr> getEncryptingParts() {
        return this.encryptingParts;
    }
}

