/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.wsee.security.policy12.assertions.Header;
import weblogic.wsee.security.policy12.assertions.SignedElements;
import weblogic.wsee.security.policy12.assertions.SignedParts;
import weblogic.wsee.security.policy12.assertions.XPath;
import weblogic.wsee.security.policy12.internal.QNameExprImpl;
import weblogic.wsee.security.wssp.IntegrityAssertion;
import weblogic.wsee.security.wssp.QNameExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrityAssertionImpl
implements IntegrityAssertion {
    private boolean isSignedBodyRequired = false;
    private boolean isSignedBodyOptional = false;
    private List<QNameExpr> signingParts = new ArrayList<QNameExpr>();
    private List<String> signingElements = new ArrayList<String>();
    private SignedElements signedElementsPolicy;
    private String xpathVersion = "1.0";
    private static final String WSA_2004_08 = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private static final String WSA_10 = "http://www.w3.org/2005/08/addressing";

    void init(SignedElements signedElements) {
        this.signedElementsPolicy = signedElements;
        String string = signedElements.getXPathVersion();
        if (string != null && string.length() > 0) {
            this.xpathVersion = string;
        }
        Iterator<XPath> iterator = signedElements.getXPathExpressions().iterator();
        while (iterator.hasNext()) {
            this.signingElements.add(iterator.next().getXPathExpr());
        }
    }

    void init(SignedParts signedParts) {
        if (signedParts.getBody() != null) {
            this.isSignedBodyRequired = true;
            this.isSignedBodyOptional = signedParts.isBodyOptional() || signedParts.getBody().isOptional() || signedParts.isOptional();
        }
        for (Header header : signedParts.getHeaders()) {
            this.signingParts.add(new QNameExprImpl(header.getHeaderName(), header.getHeaderNamespaceUri(), header.isOptional()));
        }
    }

    @Override
    public boolean isSignedBodyRequired() {
        return this.isSignedBodyRequired;
    }

    @Override
    public boolean isSignedBodyOptional() {
        return this.isSignedBodyOptional;
    }

    @Override
    public List<String> getSigningElements() {
        return this.signingElements;
    }

    @Override
    public String getXPathVersion() {
        return this.xpathVersion;
    }

    @Override
    public List<QNameExpr> getSigningParts() {
        return this.signingParts;
    }

    @Override
    public SignedElements getSignedElementsPolicy() {
        return this.signedElementsPolicy;
    }

    @Override
    public boolean isSignedWsaHeadersRequired() {
        for (QNameExpr qNameExpr : this.signingParts) {
            String string = qNameExpr.getNamespaceUri();
            if (string == null || !string.equals(WSA_2004_08) && !string.equals(WSA_10)) continue;
            return true;
        }
        return false;
    }
}

