/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import weblogic.wsee.security.policy12.assertions.Header;
import weblogic.wsee.security.policy12.assertions.RequiredElements;
import weblogic.wsee.security.policy12.assertions.RequiredParts;
import weblogic.wsee.security.policy12.assertions.XPath;
import weblogic.wsee.security.policy12.internal.QNameExprImpl;
import weblogic.wsee.security.wssp.ProtectionAssertion;
import weblogic.wsee.security.wssp.QNameExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectionAssertionImpl
implements ProtectionAssertion {
    List<String> requiredElements = new LinkedList<String>();
    private RequiredElements requiredElementsPolicy = null;
    private List<QNameExpr> requiredParts = new ArrayList<QNameExpr>();
    private RequiredParts requiredPartsPolicy = null;
    String xpathVersion = "1.0";

    ProtectionAssertionImpl(RequiredElements requiredElements) {
        this.requiredElementsPolicy = requiredElements;
        String string = requiredElements.getXPathVersion();
        if (string != null && string.length() > 0) {
            this.xpathVersion = string;
        }
        Set<XPath> set = requiredElements.getXPathExpressions();
        Iterator<XPath> iterator = set.iterator();
        while (iterator.hasNext()) {
            this.requiredElements.add(iterator.next().getXPathExpr());
        }
    }

    public ProtectionAssertionImpl(RequiredParts requiredParts) {
        if (null == requiredParts) {
            throw new IllegalArgumentException("Null Required Parts found");
        }
        this.requiredPartsPolicy = requiredParts;
        for (Header header : requiredParts.getHeaders()) {
            this.requiredParts.add(new QNameExprImpl(header.getHeaderName(), header.getHeaderNamespaceUri(), header.isOptional() || requiredParts.isOptional()));
        }
    }

    @Override
    public List<String> getRequiredElements() {
        return this.requiredElements;
    }

    @Override
    public RequiredElements getRequiredElementsPolicy() {
        return this.requiredElementsPolicy;
    }

    @Override
    public String getXPathVersion() {
        return this.xpathVersion;
    }

    @Override
    public List<QNameExpr> getRequiredParts() {
        return this.requiredParts;
    }

    @Override
    public RequiredParts getRequiredPartsPolicy() {
        return this.requiredPartsPolicy;
    }

    @Override
    public boolean hasRequiredPartsPolicy() {
        return this.requiredPartsPolicy != null;
    }
}

