/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.internal;

import weblogic.wsee.security.policy12.assertions.KerberosToken;
import weblogic.wsee.security.policy12.assertions.ProtectionToken;
import weblogic.wsee.security.policy12.assertions.SamlToken;
import weblogic.wsee.security.policy12.assertions.SecureConversationToken;
import weblogic.wsee.security.policy12.assertions.X509Token;
import weblogic.wsee.security.policy12.internal.KerberosTokenAssertionImpl;
import weblogic.wsee.security.policy12.internal.SamlTokenAssertionImpl;
import weblogic.wsee.security.policy12.internal.SecureConversationTokenAssertionImpl;
import weblogic.wsee.security.policy12.internal.X509TokenAssertionImpl;
import weblogic.wsee.security.wssp.KerberosTokenAssertion;
import weblogic.wsee.security.wssp.ProtectionTokenAssertion;
import weblogic.wsee.security.wssp.SamlTokenAssertion;
import weblogic.wsee.security.wssp.SecureConversationTokenAssertion;
import weblogic.wsee.security.wssp.X509TokenAssertion;

public class ProtectionTokenAssertionImpl
implements ProtectionTokenAssertion {
    SecureConversationTokenAssertionImpl secTokenAsstImpl;
    X509TokenAssertion x509TokenAsstImpl;
    KerberosTokenAssertion kerberosTokenAsstImpl;
    SamlTokenAssertionImpl samlTokenAsstImpl;

    ProtectionTokenAssertionImpl(ProtectionToken protectionToken) {
        SamlToken samlToken;
        KerberosToken kerberosToken;
        X509Token x509Token;
        SecureConversationToken secureConversationToken = protectionToken.getSecureConversationToken();
        if (secureConversationToken != null) {
            this.secTokenAsstImpl = new SecureConversationTokenAssertionImpl(secureConversationToken);
        }
        if ((x509Token = protectionToken.getX509Token()) != null) {
            this.x509TokenAsstImpl = new X509TokenAssertionImpl(x509Token);
        }
        if ((kerberosToken = protectionToken.getKerberosToken()) != null) {
            this.kerberosTokenAsstImpl = new KerberosTokenAssertionImpl(kerberosToken);
        }
        if ((samlToken = protectionToken.getSamlToken()) != null) {
            this.samlTokenAsstImpl = new SamlTokenAssertionImpl(samlToken);
            this.samlTokenAsstImpl.setConfirmationMethodHolderOfKey();
        }
    }

    public SecureConversationTokenAssertion getSecureConversationTokenAssertion() {
        return this.secTokenAsstImpl;
    }

    public X509TokenAssertion getX509TokenAssertion() {
        return this.x509TokenAsstImpl;
    }

    public KerberosTokenAssertion getKerberosTokenAssertion() {
        return this.kerberosTokenAsstImpl;
    }

    public SamlTokenAssertion getSamlTokenAssertion() {
        return this.samlTokenAsstImpl;
    }
}

