/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.internal;

import weblogic.wsee.security.policy12.assertions.SamlToken;
import weblogic.wsee.security.policy12.internal.TokenAssertionImpl;
import weblogic.wsee.security.wssp.SamlTokenAssertion;

public class SamlTokenAssertionImpl
extends TokenAssertionImpl
implements SamlTokenAssertion {
    private boolean isKeyIdentifierReferenceRequired = false;
    private SamlTokenAssertion.TokenType tokenType = SamlTokenAssertion.TokenType.WSS_SAML_V11_TOKEN_10;
    private SamlTokenAssertion.ConfirmationMethod confirmationMethod = SamlTokenAssertion.ConfirmationMethod.SENDER_VOUCHES;

    SamlTokenAssertionImpl(SamlToken samlToken) {
        super(samlToken);
        boolean bl = this.isKeyIdentifierReferenceRequired = samlToken.getRequireKeyIdentifierReference() != null;
        if (samlToken.getWssSamlV11Token11() != null) {
            this.tokenType = SamlTokenAssertion.TokenType.WSS_SAML_V11_TOKEN_11;
        } else if (samlToken.getWssSamlV20Token11() != null) {
            this.tokenType = SamlTokenAssertion.TokenType.WSS_SAML_V20_TOKEN_11;
        }
    }

    public boolean isKeyIdentifierReferenceRequired() {
        return this.isKeyIdentifierReferenceRequired;
    }

    public SamlTokenAssertion.TokenType getSamlTokenType() {
        return this.tokenType;
    }

    void setConfirmationMethodBearer() {
        this.confirmationMethod = SamlTokenAssertion.ConfirmationMethod.BEARER;
    }

    void setConfirmationMethodHolderOfKey() {
        this.confirmationMethod = SamlTokenAssertion.ConfirmationMethod.HOLDER_OF_KEY;
    }

    void setConfirmationMethodSenderVouches() {
        this.confirmationMethod = SamlTokenAssertion.ConfirmationMethod.SENDER_VOUCHES;
    }

    public void setSubjectConfirmationMethod(SamlTokenAssertion.ConfirmationMethod confirmationMethod) {
        this.confirmationMethod = confirmationMethod;
    }

    public SamlTokenAssertion.ConfirmationMethod getSubjectConfirmationMethod() {
        return this.confirmationMethod;
    }
}

