/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.security.policy12.assertions.BootstrapPolicy;
import weblogic.wsee.security.policy12.assertions.SecureConversationToken;
import weblogic.wsee.security.policy12.internal.SecurityContextTokenAssertionImpl;
import weblogic.wsee.security.wssp.SecureConversationTokenAssertion;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;

public class SecureConversationTokenAssertionImpl
extends SecurityContextTokenAssertionImpl
implements SecureConversationTokenAssertion {
    private static final String WS_SX_SCT_TOKEN_TYPE_V13 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct";
    private static final String WS_SX_DK_TOKEN_TYPE_V13 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk";
    private static final String[] WSSC_TOKEN_TYPES_V2005 = new String[]{"http://schemas.xmlsoap.org/ws/2005/02/sc/sct", "http://schemas.xmlsoap.org/ws/2005/02/sc/dk"};
    private static final String[] WS_SX_WSSC_TOKEN_TYPES_V13 = new String[]{"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct", "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk"};
    SecureConversationToken secToken;
    private boolean is200502 = false;
    private boolean isWSSC13 = false;

    SecureConversationTokenAssertionImpl(SecureConversationToken secureConversationToken) {
        super(secureConversationToken);
        this.secToken = secureConversationToken;
        this.is200502 = secureConversationToken.isSC200502SecurityContextToken();
        this.isWSSC13 = !this.is200502;
    }

    public String getIssuerForSecurityContextToken() {
        return this.secToken.getIssuer();
    }

    public SecurityPolicyAssertionInfo[] getBootstrapPolicy() {
        NormalizedExpression normalizedExpression;
        Set set;
        ArrayList<SecurityPolicyAssertionInfo> arrayList = new ArrayList<SecurityPolicyAssertionInfo>();
        BootstrapPolicy bootstrapPolicy = this.secToken.getBootstrapPolicy();
        if (bootstrapPolicy != null && (set = (normalizedExpression = bootstrapPolicy.getNestedPolicy()).getPolicyAlternatives()) != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo((PolicyAlternative)iterator.next());
                if (securityPolicyAssertionInfo == null) continue;
                arrayList.add(securityPolicyAssertionInfo);
            }
        }
        return arrayList.toArray(new SecurityPolicyAssertionInfo[0]);
    }

    public boolean isSC200502SecurityContextToken() {
        return this.is200502;
    }

    public boolean isWSSC13SecurityContextToken() {
        return this.isWSSC13;
    }

    public NormalizedExpression getNormalizedBootstrapPolicy() {
        return this.secToken.getNormalizedBootstrapPolicy();
    }

    public String getSctTokenType() {
        if (this.isSC200502SecurityContextToken()) {
            return "http://schemas.xmlsoap.org/ws/2005/02/sc/sct";
        }
        if (this.isWSSC13SecurityContextToken()) {
            return WS_SX_SCT_TOKEN_TYPE_V13;
        }
        return WS_SX_SCT_TOKEN_TYPE_V13;
    }

    public String getDkTokenType() {
        if (this.isSC200502SecurityContextToken()) {
            return "http://schemas.xmlsoap.org/ws/2005/02/sc/dk";
        }
        if (this.isWSSC13SecurityContextToken()) {
            return WS_SX_DK_TOKEN_TYPE_V13;
        }
        return WS_SX_DK_TOKEN_TYPE_V13;
    }

    public String[] getTokenType() {
        if (this.isSC200502SecurityContextToken()) {
            return WSSC_TOKEN_TYPES_V2005;
        }
        if (this.isWSSC13SecurityContextToken()) {
            return WS_SX_WSSC_TOKEN_TYPES_V13;
        }
        return WS_SX_WSSC_TOKEN_TYPES_V13;
    }
}

