/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.internal;

import weblogic.wsee.security.policy12.assertions.AlgorithmSuite;
import weblogic.wsee.security.policy12.assertions.Layout;
import weblogic.wsee.security.policy12.assertions.SecurityBinding;
import weblogic.wsee.security.wssp.SecurityBindingPropertiesAssertion;

public class SecurityBindingPropertiesAssertionImpl
implements SecurityBindingPropertiesAssertion {
    private SecurityBindingPropertiesAssertion.AlgorithmSuite as = SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC256_RSA15;
    private SecurityBindingPropertiesAssertion.Layout layout = SecurityBindingPropertiesAssertion.Layout.LAX;
    private boolean isTimestampRequired = false;
    private boolean isEncryptBeforeSigning = false;
    private boolean isSignatureProtectionRequired = false;
    private boolean isTokenProtectionRequired = false;
    private boolean isEntireHeaderAndBodySignatureRequired = false;
    private boolean isTimestampOptional = false;
    private boolean isEncryptBeforeSigningOptional = false;
    private boolean isSignatureProtectionOptional = false;
    private boolean isTokenProtectionOptional = false;
    private boolean isEntireHeaderAndBodySignatureOptional = false;

    SecurityBindingPropertiesAssertionImpl(SecurityBinding securityBinding) {
        this.initAlgorithmSuite(securityBinding);
        this.initLayout(securityBinding);
        if (securityBinding.getIncludeTimestamp() != null) {
            this.isTimestampRequired = true;
            if (securityBinding.getIncludeTimestamp().isOptional()) {
                this.isTimestampOptional = true;
            }
        }
        if (securityBinding.getEncryptBeforeSigning() != null) {
            this.isEncryptBeforeSigning = true;
            if (securityBinding.getEncryptBeforeSigning().isOptional()) {
                this.isEncryptBeforeSigningOptional = true;
            }
        }
        if (securityBinding.getEncryptSignature() != null) {
            this.isSignatureProtectionRequired = true;
            if (securityBinding.getEncryptSignature().isOptional()) {
                this.isSignatureProtectionOptional = true;
            }
        }
        if (securityBinding.getProtectTokens() != null) {
            this.isTokenProtectionRequired = true;
            if (securityBinding.getProtectTokens().isOptional()) {
                this.isTokenProtectionOptional = true;
            }
        }
        if (securityBinding.getOnlySignEntireHeadersAndBody() != null) {
            this.isEntireHeaderAndBodySignatureRequired = true;
            if (securityBinding.getOnlySignEntireHeadersAndBody().isOptional()) {
                this.isEntireHeaderAndBodySignatureOptional = true;
            }
        }
    }

    private void initAlgorithmSuite(SecurityBinding securityBinding) {
        AlgorithmSuite algorithmSuite = securityBinding.getAlgorithmSuite();
        if (algorithmSuite != null) {
            if (algorithmSuite.getBasic256() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC256;
            } else if (algorithmSuite.getTripleDes() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.TRIPLEDES;
            } else if (algorithmSuite.getBasic128() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC128;
            } else if (algorithmSuite.getBasic128Rsa15() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC128_RSA15;
            } else if (algorithmSuite.getBasic128Sha256() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC128_SHA256;
            } else if (algorithmSuite.getBasic128Sha256Rsa15() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC128_SHA256_RSA15;
            } else if (algorithmSuite.getBasic192() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC192;
            } else if (algorithmSuite.getBasic192Rsa15() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC192_RSA15;
            } else if (algorithmSuite.getBasic192Sha256() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC192_SHA256;
            } else if (algorithmSuite.getBasic192Sha256Rsa15() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC192_SHA256_RSA15;
            } else if (algorithmSuite.getBasic256Rsa15() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC256_RSA15;
            } else if (algorithmSuite.getBasic256Sha256() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC256_SHA256;
            } else if (algorithmSuite.getBasic256Sha256Rsa15() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC256_SHA256_RSA15;
            } else if (algorithmSuite.getTripleDesRsa15() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.TRIPLEDES_RSA15;
            } else if (algorithmSuite.getTripleDesSha256() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.TRIPLEDES_SHA256;
            } else if (algorithmSuite.getTripleDesSha256Rsa15() != null) {
                this.as = SecurityBindingPropertiesAssertion.AlgorithmSuite.TRIPLEDES_SHA256_RSA15;
            }
        }
    }

    private void initLayout(SecurityBinding securityBinding) {
        Layout layout = securityBinding.getLayout();
        if (layout != null) {
            if (layout.getLax() != null) {
                this.layout = SecurityBindingPropertiesAssertion.Layout.LAX;
            } else if (layout.getStrict() != null) {
                this.layout = SecurityBindingPropertiesAssertion.Layout.STRICT;
            } else if (layout.getLaxTsFirst() != null) {
                this.layout = SecurityBindingPropertiesAssertion.Layout.LAX_TIMESTAMP_FIRST;
            } else if (layout.getLaxTsLast() != null) {
                this.layout = SecurityBindingPropertiesAssertion.Layout.LAX_TIMESTAMP_LAST;
            }
        }
    }

    public SecurityBindingPropertiesAssertion.AlgorithmSuite getAlgorithm() {
        return this.as;
    }

    public boolean isTimestampRequired() {
        return this.isTimestampRequired;
    }

    public boolean isEncryptBeforeSigning() {
        return this.isEncryptBeforeSigning;
    }

    public boolean isSignBeforeEncrypting() {
        return !this.isEncryptBeforeSigning;
    }

    public boolean isSignatureProtectionRequired() {
        return this.isSignatureProtectionRequired;
    }

    public boolean isTokenProtectionRequired() {
        return this.isTokenProtectionRequired;
    }

    public boolean isEntireHeaderAndBodySignatureRequired() {
        return this.isEntireHeaderAndBodySignatureRequired;
    }

    public SecurityBindingPropertiesAssertion.Layout getLayout() {
        return this.layout;
    }

    public boolean isTimestampOptional() {
        return this.isTimestampOptional;
    }

    public boolean isEncryptBeforeSigningOptional() {
        return this.isEncryptBeforeSigningOptional;
    }

    public boolean isSignatureProtectionOptional() {
        return this.isSignatureProtectionOptional;
    }

    public boolean isTokenProtectionOptional() {
        return this.isTokenProtectionOptional;
    }

    public boolean isEntireHeaderAndBodySignatureOptional() {
        return this.isEntireHeaderAndBodySignatureOptional;
    }
}

