/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.internal;

import java.util.ArrayList;
import java.util.List;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.security.policy12.assertions.AsymmetricBinding;
import weblogic.wsee.security.policy12.assertions.EncryptedElements;
import weblogic.wsee.security.policy12.assertions.EncryptedParts;
import weblogic.wsee.security.policy12.assertions.EncryptedSupportingTokens;
import weblogic.wsee.security.policy12.assertions.EndorsingSupportingTokens;
import weblogic.wsee.security.policy12.assertions.RequiredElements;
import weblogic.wsee.security.policy12.assertions.RequiredParts;
import weblogic.wsee.security.policy12.assertions.SignedElements;
import weblogic.wsee.security.policy12.assertions.SignedEncryptedSupportingTokens;
import weblogic.wsee.security.policy12.assertions.SignedEndorsingSupportingTokens;
import weblogic.wsee.security.policy12.assertions.SignedParts;
import weblogic.wsee.security.policy12.assertions.SignedSupportingTokens;
import weblogic.wsee.security.policy12.assertions.SupportingTokens;
import weblogic.wsee.security.policy12.assertions.SymmetricBinding;
import weblogic.wsee.security.policy12.assertions.TransportBinding;
import weblogic.wsee.security.policy12.assertions.Trust10;
import weblogic.wsee.security.policy12.assertions.Trust13;
import weblogic.wsee.security.policy12.assertions.Wss10;
import weblogic.wsee.security.policy12.assertions.Wss11;
import weblogic.wsee.security.policy12.internal.AsymmetricBindingInfoImpl;
import weblogic.wsee.security.policy12.internal.Basic128AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.Basic128Rsa15AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.Basic128Sha256AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.Basic128Sha256Rsa15AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.Basic192AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.Basic192Rsa15AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.Basic192Sha256AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.Basic192Sha256Rsa15AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.Basic256AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.Basic256Rsa15AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.Basic256Sha256AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.Basic256Sha256Rsa15AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.ConfidentialityAssertionImpl;
import weblogic.wsee.security.policy12.internal.IntegrityAssertionImpl;
import weblogic.wsee.security.policy12.internal.ProtectionAssertionImpl;
import weblogic.wsee.security.policy12.internal.SamlTokenAssertionImpl;
import weblogic.wsee.security.policy12.internal.SecurityBindingPropertiesAssertionImpl;
import weblogic.wsee.security.policy12.internal.SupportingTokensAssertionImpl;
import weblogic.wsee.security.policy12.internal.SymmetricBindingInfoImpl;
import weblogic.wsee.security.policy12.internal.TransportBindingInfoImpl;
import weblogic.wsee.security.policy12.internal.TripleDesAlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.TripleDesRsa15AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.TripleDesSha256AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.TripleDesSha256Rsa15AlgorithmSuiteInfoImpl;
import weblogic.wsee.security.policy12.internal.WsTrustOptionsImpl;
import weblogic.wsee.security.policy12.internal.Wss10OptionsImpl;
import weblogic.wsee.security.policy12.internal.Wss11OptionsImpl;
import weblogic.wsee.security.wssp.AlgorithmSuiteInfo;
import weblogic.wsee.security.wssp.AsymmetricBindingInfo;
import weblogic.wsee.security.wssp.ConfidentialityAssertion;
import weblogic.wsee.security.wssp.HttpsTokenAssertion;
import weblogic.wsee.security.wssp.IntegrityAssertion;
import weblogic.wsee.security.wssp.ProtectionAssertion;
import weblogic.wsee.security.wssp.SecureConversationTokenAssertion;
import weblogic.wsee.security.wssp.SecurityBindingPropertiesAssertion;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;
import weblogic.wsee.security.wssp.SupportingTokensAssertion;
import weblogic.wsee.security.wssp.SymmetricBindingInfo;
import weblogic.wsee.security.wssp.TokenAssertion;
import weblogic.wsee.security.wssp.TransportBindingInfo;
import weblogic.wsee.security.wssp.WsTrustOptions;
import weblogic.wsee.security.wssp.Wss10Options;
import weblogic.wsee.security.wssp.Wss11Options;
import weblogic.wsee.util.Verbose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyAssertionInfoImpl
implements SecurityPolicyAssertionInfo {
    private static final boolean verbose = Verbose.isVerbose(SecurityPolicyAssertionInfo.class) || Verbose.isVerbose(SecurityPolicyAssertionInfoImpl.class);
    private boolean hasMessageLevelSecurity = false;
    private TransportBindingInfoImpl transportBinding = null;
    private SymmetricBindingInfoImpl symmetricBinding = null;
    private AsymmetricBindingInfoImpl asymmetricBiding = null;
    private SupportingTokensAssertionImpl supportingTokens = null;
    private WsTrustOptionsImpl trustOptions = null;
    private Wss10OptionsImpl wss10Options = null;
    private Wss11OptionsImpl wss11Options = null;
    private List<ProtectionAssertion> protectionAssts = null;
    private List<ConfidentialityAssertion> confidentialityAssts = null;
    private List<IntegrityAssertion> integrityAssts = null;
    private AlgorithmSuiteInfo algSuiteInfoImpl;
    private List ufo = null;
    private String namespaceUri = null;
    private boolean needFurtherSamlConfirmVerification = false;

    @Override
    public void init(PolicyAlternative policyAlternative) {
        for (PolicyAssertion policyAssertion : policyAlternative.getAssertions()) {
            Object object;
            if (null == policyAssertion.getName()) {
                if (verbose) {
                    Verbose.log("Found an unknown assertion " + policyAssertion);
                }
                this.reportUfo(policyAssertion);
                continue;
            }
            String string = policyAssertion.getName().getNamespaceURI();
            if (!("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702".equals(string) || "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200512".equals(string) || "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(string))) {
                if (verbose) {
                    Verbose.log("Bypass non-security assertion " + policyAssertion.getName());
                }
                this.reportUfo(policyAssertion);
                continue;
            }
            if (policyAssertion instanceof SymmetricBinding) {
                this.symmetricBinding = new SymmetricBindingInfoImpl((SymmetricBinding)policyAssertion);
                this.algSuiteInfoImpl = SecurityPolicyAssertionInfoImpl.getAlgorithmSuiteInfo(this.symmetricBinding.getAlgorithm());
                this.hasMessageLevelSecurity = true;
                this.namespaceUri = string;
                continue;
            }
            if (policyAssertion instanceof AsymmetricBinding) {
                this.asymmetricBiding = new AsymmetricBindingInfoImpl((AsymmetricBinding)policyAssertion);
                this.algSuiteInfoImpl = SecurityPolicyAssertionInfoImpl.getAlgorithmSuiteInfo(this.asymmetricBiding.getAlgorithm());
                this.hasMessageLevelSecurity = true;
                this.namespaceUri = string;
                continue;
            }
            if (policyAssertion instanceof Wss11) {
                this.wss11Options = new Wss11OptionsImpl((Wss11)policyAssertion);
                if (null != this.namespaceUri) continue;
                this.namespaceUri = string;
                continue;
            }
            if (policyAssertion instanceof Wss10) {
                this.wss10Options = new Wss10OptionsImpl((Wss10)policyAssertion);
                continue;
            }
            if (policyAssertion instanceof SignedParts) {
                object = this.getIntegrityAssertionImplInstance();
                ((IntegrityAssertionImpl)object).init((SignedParts)policyAssertion);
                if (null == this.namespaceUri) {
                    this.namespaceUri = string;
                }
                if (this.integrityAssts == null) {
                    this.integrityAssts = new ArrayList<IntegrityAssertion>();
                }
                this.integrityAssts.add((IntegrityAssertion)object);
                continue;
            }
            if (policyAssertion instanceof EncryptedParts) {
                object = this.getConfidentialityAssertionImplInstance();
                ((ConfidentialityAssertionImpl)object).init((EncryptedParts)policyAssertion);
                if (this.confidentialityAssts == null) {
                    this.confidentialityAssts = new ArrayList<ConfidentialityAssertion>();
                }
                this.confidentialityAssts.add((ConfidentialityAssertion)object);
                continue;
            }
            if (policyAssertion instanceof EncryptedElements) {
                object = this.getConfidentialityAssertionImplInstance();
                ((ConfidentialityAssertionImpl)object).init((EncryptedElements)policyAssertion);
                if (this.confidentialityAssts == null) {
                    this.confidentialityAssts = new ArrayList<ConfidentialityAssertion>();
                }
                this.confidentialityAssts.add((ConfidentialityAssertion)object);
                continue;
            }
            if (policyAssertion instanceof SupportingTokens) {
                this.getSupportingTokensAssertionInstance().initSupportingTokens((SupportingTokens)policyAssertion);
                this.hasMessageLevelSecurity = true;
                continue;
            }
            if (policyAssertion instanceof SignedSupportingTokens) {
                this.getSupportingTokensAssertionInstance().initSignedSupportingTokens((SignedSupportingTokens)policyAssertion);
                this.needFurtherSamlConfirmVerification = this.supportingTokens.isVerifySamlConfirmation();
                continue;
            }
            if (policyAssertion instanceof EncryptedSupportingTokens) {
                this.getSupportingTokensAssertionInstance().initEncryptedSupportingTokens((EncryptedSupportingTokens)policyAssertion);
                continue;
            }
            if (policyAssertion instanceof SignedEncryptedSupportingTokens) {
                this.getSupportingTokensAssertionInstance().initSignedEncryptedSupportingTokens((SignedEncryptedSupportingTokens)policyAssertion);
                this.needFurtherSamlConfirmVerification = this.supportingTokens.isVerifySamlConfirmation();
                continue;
            }
            if (policyAssertion instanceof EndorsingSupportingTokens) {
                this.getSupportingTokensAssertionInstance().initEndorsingSupportingTokens((EndorsingSupportingTokens)policyAssertion);
                continue;
            }
            if (policyAssertion instanceof SignedEndorsingSupportingTokens) {
                this.getSupportingTokensAssertionInstance().initSignedEndorsingSupportingTokens((SignedEndorsingSupportingTokens)policyAssertion);
                continue;
            }
            if (policyAssertion instanceof RequiredParts) {
                object = new ProtectionAssertionImpl((RequiredParts)policyAssertion);
                this.hasMessageLevelSecurity = true;
                if (this.protectionAssts == null) {
                    this.protectionAssts = new ArrayList<ProtectionAssertion>();
                }
                this.protectionAssts.add((ProtectionAssertion)object);
                continue;
            }
            if (policyAssertion instanceof RequiredElements) {
                object = new ProtectionAssertionImpl((RequiredElements)policyAssertion);
                this.hasMessageLevelSecurity = true;
                if (this.protectionAssts == null) {
                    this.protectionAssts = new ArrayList<ProtectionAssertion>();
                }
                this.protectionAssts.add((ProtectionAssertion)object);
                continue;
            }
            if (policyAssertion instanceof SignedElements) {
                object = this.getIntegrityAssertionImplInstance();
                ((IntegrityAssertionImpl)object).init((SignedElements)policyAssertion);
                if (this.integrityAssts == null) {
                    this.integrityAssts = new ArrayList<IntegrityAssertion>();
                }
                this.integrityAssts.add((IntegrityAssertion)object);
                continue;
            }
            if (policyAssertion instanceof TransportBinding) {
                if (null == this.transportBinding) {
                    this.transportBinding = new TransportBindingInfoImpl((TransportBinding)policyAssertion);
                    this.algSuiteInfoImpl = SecurityPolicyAssertionInfoImpl.getAlgorithmSuiteInfo(this.transportBinding.getAlgorithm());
                    continue;
                }
                object = new TransportBindingInfoImpl((TransportBinding)policyAssertion);
                if (this.countHttpsTokenAssertion((TransportBindingInfoImpl)object) <= this.countHttpsTokenAssertion(this.transportBinding)) continue;
                this.transportBinding = object;
                this.algSuiteInfoImpl = SecurityPolicyAssertionInfoImpl.getAlgorithmSuiteInfo(((SecurityBindingPropertiesAssertionImpl)object).getAlgorithm());
                continue;
            }
            if (policyAssertion instanceof Trust13) {
                this.trustOptions = new WsTrustOptionsImpl((Trust13)policyAssertion);
                continue;
            }
            if (policyAssertion instanceof Trust10) {
                this.trustOptions = new WsTrustOptionsImpl((Trust10)policyAssertion);
                continue;
            }
            if (verbose) {
                Verbose.log("Unsported security assertion " + policyAssertion.getName());
            }
            this.reportUfo(policyAssertion);
        }
        this.postInit();
    }

    private int countHttpsTokenAssertion(TransportBindingInfoImpl transportBindingInfoImpl) {
        if (null == transportBindingInfoImpl) {
            return -2;
        }
        int n = 0;
        HttpsTokenAssertion httpsTokenAssertion = transportBindingInfoImpl.getHttpsTokenAssertion();
        if (httpsTokenAssertion == null) {
            return -1;
        }
        ++n;
        if (httpsTokenAssertion.isClientCertificateRequired()) {
            n += 2;
        }
        if (httpsTokenAssertion.isHttpBasicAuthenticationRequired()) {
            ++n;
        }
        return n;
    }

    private void reportUfo(PolicyAssertion policyAssertion) {
        if (null == policyAssertion) {
            if (verbose) {
                Verbose.log("Found an unidentified null security assertion ");
            }
            return;
        }
        if (this.ufo == null) {
            this.ufo = new ArrayList();
        }
        this.ufo.add(policyAssertion);
        if (verbose) {
            if (null == policyAssertion.getPolicySubject()) {
                Verbose.log("Found an unidentified security assertion " + policyAssertion + " Name =" + policyAssertion.getName() + " Subject = NULL");
            } else {
                Verbose.log("Found an unidentified security assertion " + policyAssertion + " Name =" + policyAssertion.getName() + " Subject " + policyAssertion.getPolicySubject().name());
            }
        }
    }

    private void postInit() {
        Object object;
        List<TokenAssertion> list;
        if (this.confidentialityAssts != null && this.wss11Options != null) {
            list = this.confidentialityAssts.iterator();
            while (list.hasNext()) {
                object = (ConfidentialityAssertionImpl)list.next();
                if (((ConfidentialityAssertionImpl)object).getEncryptingElements().size() <= 0 && ((ConfidentialityAssertionImpl)object).getEncryptingParts().size() <= 0) continue;
                ((ConfidentialityAssertionImpl)object).setEncryptedHeaderRequired(true);
            }
        }
        if (this.symmetricBinding != null && this.wss11Options != null && (list = this.symmetricBinding.getProtectionTokenAssertion()) != null && (object = list.getX509TokenAssertion()) != null && TokenAssertion.TokenInclusion.NEVER.equals((Object)object.getTokenInclusion())) {
            this.symmetricBinding.setEncryptedKeyRequired(true);
        }
        if (this.symmetricBinding != null && this.needFurtherSamlConfirmVerification && !this.supportingTokens.hasEndorsingSupportingTokens() && !this.supportingTokens.hasSignedEndorsingSupportingTokens()) {
            list = null;
            if (this.supportingTokens.hasSignedSupportingTokens()) {
                list = this.supportingTokens.getSignedSupportingTokens();
            }
            if (this.supportingTokens.hasSignedEncryptedSupportingTokens()) {
                list = this.supportingTokens.getSignedEncryptedSupportingTokens();
            }
            if (null != list && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof SamlTokenAssertionImpl)) continue;
                    SamlTokenAssertionImpl samlTokenAssertionImpl = (SamlTokenAssertionImpl)list.get(i);
                    samlTokenAssertionImpl.setConfirmationMethodBearer();
                }
            }
        }
    }

    private static AlgorithmSuiteInfo getAlgorithmSuiteInfo(SecurityBindingPropertiesAssertion.AlgorithmSuite algorithmSuite) {
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC256)) {
            return new Basic256AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.TRIPLEDES_RSA15)) {
            return new TripleDesRsa15AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC192)) {
            return new Basic192AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC128)) {
            return new Basic128AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.TRIPLEDES)) {
            return new TripleDesAlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC256_RSA15)) {
            return new Basic256Rsa15AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC192_RSA15)) {
            return new Basic192Rsa15AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC128_RSA15)) {
            return new Basic128Rsa15AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC256_SHA256)) {
            return new Basic256Sha256AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC192_SHA256)) {
            return new Basic192Sha256AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC128_SHA256)) {
            return new Basic128Sha256AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.TRIPLEDES_SHA256)) {
            return new TripleDesSha256AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC256_SHA256_RSA15)) {
            return new Basic256Sha256Rsa15AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC192_SHA256_RSA15)) {
            return new Basic192Sha256Rsa15AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.BASIC128_SHA256_RSA15)) {
            return new Basic128Sha256Rsa15AlgorithmSuiteInfoImpl();
        }
        if (algorithmSuite.equals((Object)SecurityBindingPropertiesAssertion.AlgorithmSuite.TRIPLEDES_SHA256_RSA15)) {
            return new TripleDesSha256Rsa15AlgorithmSuiteInfoImpl();
        }
        if (verbose) {
            Verbose.log("Found an unidentified AlgorithmSuite " + (Object)((Object)algorithmSuite) + " Name =" + algorithmSuite.name());
        }
        return new Basic256AlgorithmSuiteInfoImpl();
    }

    private IntegrityAssertionImpl getIntegrityAssertionImplInstance() {
        return new IntegrityAssertionImpl();
    }

    private ConfidentialityAssertionImpl getConfidentialityAssertionImplInstance() {
        return new ConfidentialityAssertionImpl();
    }

    private SupportingTokensAssertionImpl getSupportingTokensAssertionInstance() {
        if (this.supportingTokens == null) {
            this.supportingTokens = new SupportingTokensAssertionImpl();
        }
        return this.supportingTokens;
    }

    @Override
    public SymmetricBindingInfo getSymmetricBindingInfo() {
        return this.symmetricBinding;
    }

    @Override
    public AsymmetricBindingInfo getAsymmetricBindingInfo() {
        return this.asymmetricBiding;
    }

    @Override
    public SupportingTokensAssertion getSupportingTokensAssertion() {
        return this.supportingTokens;
    }

    @Override
    public WsTrustOptions getWsTrustOptions() {
        return this.trustOptions;
    }

    @Override
    public NormalizedExpression getWsTrustBootstrapPolicy() {
        Object object;
        Object object2;
        if (this.symmetricBinding != null && (object2 = this.symmetricBinding.getProtectionTokenAssertion()) != null && (object = object2.getSecureConversationTokenAssertion()) != null) {
            return object.getNormalizedBootstrapPolicy();
        }
        if (this.supportingTokens != null) {
            object2 = new ArrayList();
            object2.addAll(this.supportingTokens.getSupportingTokens());
            object2.addAll(this.supportingTokens.getSignedSupportingTokens());
            object2.addAll(this.supportingTokens.getEncryptedSupportingTokens());
            object2.addAll(this.supportingTokens.getSignedEncryptedSupportingTokens());
            object2.addAll(this.supportingTokens.getEndorsingSupportingTokens());
            object2.addAll(this.supportingTokens.getSignedEndorsingSupportingTokens());
            object = object2.iterator();
            while (object.hasNext()) {
                TokenAssertion tokenAssertion = (TokenAssertion)object.next();
                if (!(tokenAssertion instanceof SecureConversationTokenAssertion)) continue;
                return ((SecureConversationTokenAssertion)tokenAssertion).getNormalizedBootstrapPolicy();
            }
        }
        return null;
    }

    @Override
    public Wss10Options getWss10Options() {
        return this.wss10Options;
    }

    @Override
    public Wss11Options getWss11Options() {
        return this.wss11Options;
    }

    @Override
    public List<IntegrityAssertion> getIntegrityAssertions() {
        return this.integrityAssts;
    }

    @Override
    public IntegrityAssertion getIntegrityAssertion() {
        if (this.integrityAssts == null || this.integrityAssts.size() != 1) {
            return null;
        }
        return this.integrityAssts.get(0);
    }

    @Override
    public ConfidentialityAssertion getConfidentialityAssertion() {
        if (this.confidentialityAssts == null || this.confidentialityAssts.size() != 1) {
            return null;
        }
        return this.confidentialityAssts.get(0);
    }

    @Override
    public List<ConfidentialityAssertion> getConfidentialityAssertions() {
        return this.confidentialityAssts;
    }

    @Override
    public List<ProtectionAssertion> getProtectionAssertions() {
        return this.protectionAssts;
    }

    @Override
    public AlgorithmSuiteInfo getAlgorithmSuiteInfo() {
        return this.algSuiteInfoImpl;
    }

    @Override
    public boolean isMessageSecurityEnabled() {
        return this.hasMessageLevelSecurity;
    }

    @Override
    public TransportBindingInfo getTransportBindingInfo() {
        return this.transportBinding;
    }

    @Override
    public boolean hasUnidentifiedAssertion() {
        return this.ufo != null && this.ufo.size() > 0;
    }

    @Override
    public List getUnidentifiedAssertions() {
        return this.ufo;
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }
}

