/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.internal;

import java.util.ArrayList;
import java.util.List;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.security.policy12.assertions.AbstractSupportingTokens;
import weblogic.wsee.security.policy12.assertions.EncryptedSupportingTokens;
import weblogic.wsee.security.policy12.assertions.EndorsingSupportingTokens;
import weblogic.wsee.security.policy12.assertions.IssuedToken;
import weblogic.wsee.security.policy12.assertions.KerberosToken;
import weblogic.wsee.security.policy12.assertions.SamlToken;
import weblogic.wsee.security.policy12.assertions.SecureConversationToken;
import weblogic.wsee.security.policy12.assertions.SignedEncryptedSupportingTokens;
import weblogic.wsee.security.policy12.assertions.SignedEndorsingSupportingTokens;
import weblogic.wsee.security.policy12.assertions.SignedSupportingTokens;
import weblogic.wsee.security.policy12.assertions.SupportingTokens;
import weblogic.wsee.security.policy12.assertions.UsernameToken;
import weblogic.wsee.security.policy12.assertions.X509Token;
import weblogic.wsee.security.policy12.internal.IssuedTokenAssertionImpl;
import weblogic.wsee.security.policy12.internal.KerberosTokenAssertionImpl;
import weblogic.wsee.security.policy12.internal.SamlTokenAssertionImpl;
import weblogic.wsee.security.policy12.internal.SecureConversationTokenAssertionImpl;
import weblogic.wsee.security.policy12.internal.TokenAssertionImpl;
import weblogic.wsee.security.policy12.internal.UsernameTokenAssertionImpl;
import weblogic.wsee.security.policy12.internal.X509TokenAssertionImpl;
import weblogic.wsee.security.wssp.SamlTokenAssertion;
import weblogic.wsee.security.wssp.SupportingTokensAssertion;
import weblogic.wsee.security.wssp.TokenAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportingTokensAssertionImpl
implements SupportingTokensAssertion {
    private List<TokenAssertion> supportingTokens = new ArrayList<TokenAssertion>();
    private List<TokenAssertion> encryptedSupportingTokens = new ArrayList<TokenAssertion>();
    private List<TokenAssertion> signedSupportingTokens = new ArrayList<TokenAssertion>();
    private List<TokenAssertion> signedEncryptedSupportingTokens = new ArrayList<TokenAssertion>();
    private List<TokenAssertion> endorsingSupportingTokens = new ArrayList<TokenAssertion>();
    private List<TokenAssertion> signedEndorsingSupportingTokens = new ArrayList<TokenAssertion>();
    private SupportingTokensAssertion.SecurityInfo siOfSupportingTokens = new SupportingTokensAssertion.SecurityInfo();
    private SupportingTokensAssertion.SecurityInfo siOfEncryptedSupportingTokens = new SupportingTokensAssertion.SecurityInfo();
    private SupportingTokensAssertion.SecurityInfo siOfSignedSupportingTokens = new SupportingTokensAssertion.SecurityInfo();
    private SupportingTokensAssertion.SecurityInfo siOfSignedEncryptedSupportingTokens = new SupportingTokensAssertion.SecurityInfo();
    private SupportingTokensAssertion.SecurityInfo siOfEndorsingSupportingTokens = new SupportingTokensAssertion.SecurityInfo();
    private SupportingTokensAssertion.SecurityInfo siOfSignedEndorsingSupportingTokens = new SupportingTokensAssertion.SecurityInfo();
    private boolean verifySamlConfirmation = false;

    SupportingTokensAssertionImpl() {
    }

    void initSupportingTokens(SupportingTokens supportingTokens) {
        SupportingTokensAssertionImpl.addTokensNoSaml(supportingTokens, this.supportingTokens);
        SupportingTokensAssertionImpl.addSamlTokens(supportingTokens, this.supportingTokens, SamlTokenAssertion.ConfirmationMethod.BEARER);
        this.siOfSupportingTokens.init(supportingTokens);
    }

    void initSignedSupportingTokens(SignedSupportingTokens signedSupportingTokens) {
        SupportingTokensAssertionImpl.addTokensNoSaml(signedSupportingTokens, this.signedSupportingTokens);
        if (SupportingTokensAssertionImpl.addSamlTokens(signedSupportingTokens, this.signedSupportingTokens, SamlTokenAssertion.ConfirmationMethod.SENDER_VOUCHES)) {
            this.verifySamlConfirmation = true;
        }
        this.siOfSignedSupportingTokens.init(signedSupportingTokens);
    }

    void initSignedEncryptedSupportingTokens(SignedEncryptedSupportingTokens signedEncryptedSupportingTokens) {
        SupportingTokensAssertionImpl.addTokensNoSaml(signedEncryptedSupportingTokens, this.signedEncryptedSupportingTokens);
        if (SupportingTokensAssertionImpl.addSamlTokens(signedEncryptedSupportingTokens, this.signedEncryptedSupportingTokens, SamlTokenAssertion.ConfirmationMethod.SENDER_VOUCHES)) {
            this.verifySamlConfirmation = true;
        }
        this.siOfSignedEncryptedSupportingTokens.init(signedEncryptedSupportingTokens);
    }

    void initEncryptedSupportingTokens(EncryptedSupportingTokens encryptedSupportingTokens) {
        SupportingTokensAssertionImpl.addTokensNoSaml(encryptedSupportingTokens, this.encryptedSupportingTokens);
        SupportingTokensAssertionImpl.addSamlTokens(encryptedSupportingTokens, this.encryptedSupportingTokens, SamlTokenAssertion.ConfirmationMethod.BEARER);
        this.siOfEncryptedSupportingTokens.init(encryptedSupportingTokens);
    }

    void initEndorsingSupportingTokens(EndorsingSupportingTokens endorsingSupportingTokens) {
        SupportingTokensAssertionImpl.addTokensNoSaml(endorsingSupportingTokens, this.endorsingSupportingTokens);
        SupportingTokensAssertionImpl.addSamlTokens(endorsingSupportingTokens, this.endorsingSupportingTokens, SamlTokenAssertion.ConfirmationMethod.HOLDER_OF_KEY);
        this.siOfEndorsingSupportingTokens.init(endorsingSupportingTokens);
    }

    void initSignedEndorsingSupportingTokens(SignedEndorsingSupportingTokens signedEndorsingSupportingTokens) {
        SupportingTokensAssertionImpl.addTokensNoSaml(signedEndorsingSupportingTokens, this.signedEndorsingSupportingTokens);
        SupportingTokensAssertionImpl.addSamlTokens(signedEndorsingSupportingTokens, this.signedEndorsingSupportingTokens, SamlTokenAssertion.ConfirmationMethod.HOLDER_OF_KEY);
        this.siOfSignedEndorsingSupportingTokens.init(signedEndorsingSupportingTokens);
    }

    private static void addTokensNoSaml(AbstractSupportingTokens abstractSupportingTokens, List<TokenAssertion> list) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        UsernameToken usernameToken = abstractSupportingTokens.getUsernameToken();
        if (usernameToken != null) {
            object4 = new UsernameTokenAssertionImpl(usernameToken);
            if (abstractSupportingTokens.isOptional()) {
                ((TokenAssertionImpl)object4).setOptional(abstractSupportingTokens.getOptional());
            }
            list.add((TokenAssertion)object4);
        }
        if ((object4 = abstractSupportingTokens.getX509Token()) != null) {
            object3 = new X509TokenAssertionImpl((X509Token)object4);
            if (abstractSupportingTokens.isOptional()) {
                object3.setOptional(abstractSupportingTokens.getOptional());
            }
            list.add((TokenAssertion)object3);
        }
        if ((object3 = abstractSupportingTokens.getSecureConversationToken()) != null) {
            object2 = new SecureConversationTokenAssertionImpl((SecureConversationToken)object3);
            if (abstractSupportingTokens.isOptional()) {
                ((TokenAssertionImpl)object2).setOptional(((PolicyAssertion)object3).isOptional());
            }
            list.add((TokenAssertion)object2);
        }
        if ((object2 = abstractSupportingTokens.getKerberosToken()) != null) {
            object = new KerberosTokenAssertionImpl((KerberosToken)object2);
            if (((PolicyAssertion)object2).isOptional()) {
                ((TokenAssertionImpl)object).setOptional(true);
            }
            list.add((TokenAssertion)object);
        }
        if ((object = abstractSupportingTokens.getIssuedToken()) != null) {
            IssuedTokenAssertionImpl issuedTokenAssertionImpl = new IssuedTokenAssertionImpl((IssuedToken)object);
            if (((PolicyAssertion)object).isOptional()) {
                issuedTokenAssertionImpl.setOptional(true);
            }
            list.add(issuedTokenAssertionImpl);
        }
    }

    private static boolean addSamlTokens(AbstractSupportingTokens abstractSupportingTokens, List<TokenAssertion> list, SamlTokenAssertion.ConfirmationMethod confirmationMethod) {
        SamlToken samlToken = abstractSupportingTokens.getSamlToken();
        if (samlToken == null) {
            return false;
        }
        SamlTokenAssertionImpl samlTokenAssertionImpl = new SamlTokenAssertionImpl(samlToken);
        if (abstractSupportingTokens.isOptional()) {
            samlTokenAssertionImpl.setOptional(abstractSupportingTokens.getOptional());
        }
        samlTokenAssertionImpl.setSubjectConfirmationMethod(confirmationMethod);
        list.add(samlTokenAssertionImpl);
        return true;
    }

    @Override
    public boolean hasSupportingTokens() {
        return this.supportingTokens.size() > 0;
    }

    @Override
    public List<TokenAssertion> getSupportingTokens() {
        return this.supportingTokens;
    }

    @Override
    public SupportingTokensAssertion.SecurityInfo getSecurityInfoOfSupportingTokens() {
        return this.siOfSupportingTokens;
    }

    @Override
    public boolean hasSignedSupportingTokens() {
        return this.signedSupportingTokens.size() > 0;
    }

    @Override
    public List<TokenAssertion> getSignedSupportingTokens() {
        return this.signedSupportingTokens;
    }

    @Override
    public SupportingTokensAssertion.SecurityInfo getSecurityInfoOfSignedSupportingTokens() {
        return this.siOfSignedSupportingTokens;
    }

    @Override
    public boolean hasSignedEncryptedSupportingTokens() {
        return this.signedEncryptedSupportingTokens.size() > 0;
    }

    @Override
    public List<TokenAssertion> getSignedEncryptedSupportingTokens() {
        return this.signedEncryptedSupportingTokens;
    }

    @Override
    public SupportingTokensAssertion.SecurityInfo getSecurityInfoOfSignedEncryptedSupportingTokens() {
        return this.siOfSignedEncryptedSupportingTokens;
    }

    @Override
    public boolean hasEncryptedSupportingTokens() {
        return this.encryptedSupportingTokens.size() > 0;
    }

    @Override
    public List<TokenAssertion> getEncryptedSupportingTokens() {
        return this.encryptedSupportingTokens;
    }

    @Override
    public SupportingTokensAssertion.SecurityInfo getSecurityInfoOfEncryptedSupportingTokens() {
        return this.siOfEncryptedSupportingTokens;
    }

    @Override
    public boolean hasEndorsingSupportingTokens() {
        return this.endorsingSupportingTokens.size() > 0;
    }

    @Override
    public List<TokenAssertion> getEndorsingSupportingTokens() {
        return this.endorsingSupportingTokens;
    }

    @Override
    public SupportingTokensAssertion.SecurityInfo getSecurityInfoOfEndorsingSupportingTokens() {
        return this.siOfEndorsingSupportingTokens;
    }

    @Override
    public boolean hasSignedEndorsingSupportingTokens() {
        return this.signedEndorsingSupportingTokens.size() > 0;
    }

    @Override
    public List<TokenAssertion> getSignedEndorsingSupportingTokens() {
        return this.signedEndorsingSupportingTokens;
    }

    @Override
    public SupportingTokensAssertion.SecurityInfo getSecurityInfoOfSignedEndorsingSupportingTokens() {
        return this.siOfSignedEndorsingSupportingTokens;
    }

    @Override
    public boolean isEncryptedBodyRequired() {
        SupportingTokensAssertion.SecurityInfo[] securityInfoArray = new SupportingTokensAssertion.SecurityInfo[]{this.siOfSupportingTokens, this.siOfEncryptedSupportingTokens, this.siOfSignedSupportingTokens, this.siOfSignedEncryptedSupportingTokens, this.siOfEndorsingSupportingTokens, this.siOfSignedEndorsingSupportingTokens};
        for (int i = 0; i < securityInfoArray.length; ++i) {
            if (!securityInfoArray[i].isEncryptedBodyRequired()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEncryptedBodyOptional() {
        SupportingTokensAssertion.SecurityInfo[] securityInfoArray = new SupportingTokensAssertion.SecurityInfo[]{this.siOfSupportingTokens, this.siOfEncryptedSupportingTokens, this.siOfSignedSupportingTokens, this.siOfSignedEncryptedSupportingTokens, this.siOfEndorsingSupportingTokens, this.siOfSignedEndorsingSupportingTokens};
        for (int i = 0; i < securityInfoArray.length; ++i) {
            if (!securityInfoArray[i].isEncryptedBodyOptional()) continue;
            return true;
        }
        return false;
    }

    public boolean isVerifySamlConfirmation() {
        return this.verifySamlConfirmation;
    }
}

