/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.internal;

import weblogic.wsee.security.policy12.assertions.EncryptionToken;
import weblogic.wsee.security.policy12.assertions.ProtectionToken;
import weblogic.wsee.security.policy12.assertions.SignatureToken;
import weblogic.wsee.security.policy12.assertions.SymmetricBinding;
import weblogic.wsee.security.policy12.internal.EncryptionTokenAssertionImpl;
import weblogic.wsee.security.policy12.internal.ProtectionTokenAssertionImpl;
import weblogic.wsee.security.policy12.internal.SecurityBindingPropertiesAssertionImpl;
import weblogic.wsee.security.policy12.internal.SignatureTokenAssertionImpl;
import weblogic.wsee.security.wssp.EncryptionTokenAssertion;
import weblogic.wsee.security.wssp.ProtectionTokenAssertion;
import weblogic.wsee.security.wssp.SignatureTokenAssertion;
import weblogic.wsee.security.wssp.SymmetricBindingInfo;

public class SymmetricBindingInfoImpl
extends SecurityBindingPropertiesAssertionImpl
implements SymmetricBindingInfo {
    private SignatureTokenAssertionImpl sigToken;
    private EncryptionTokenAssertionImpl encToken;
    private ProtectionTokenAssertionImpl protectToken;
    private boolean encryptedKeyRequired = false;

    SymmetricBindingInfoImpl(SymmetricBinding symmetricBinding) {
        super(symmetricBinding);
        ProtectionToken protectionToken;
        EncryptionToken encryptionToken;
        SignatureToken signatureToken = symmetricBinding.getSignatureToken();
        if (signatureToken != null) {
            this.sigToken = new SignatureTokenAssertionImpl(signatureToken);
        }
        if ((encryptionToken = symmetricBinding.getEncryptionToken()) != null) {
            this.encToken = new EncryptionTokenAssertionImpl(encryptionToken);
        }
        if ((protectionToken = symmetricBinding.getProtectionToken()) != null) {
            this.protectToken = new ProtectionTokenAssertionImpl(protectionToken);
        }
    }

    public SignatureTokenAssertion getSignatureTokenAssertion() {
        return this.sigToken;
    }

    public EncryptionTokenAssertion getEncryptionTokenAssertion() {
        return this.encToken;
    }

    public ProtectionTokenAssertion getProtectionTokenAssertion() {
        return this.protectToken;
    }

    public boolean isEncryptedKeyRequired() {
        return this.encryptedKeyRequired;
    }

    void setEncryptedKeyRequired(boolean bl) {
        this.encryptedKeyRequired = bl;
    }
}

