/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.internal;

import weblogic.wsee.security.policy12.assertions.Token;
import weblogic.wsee.security.wssp.TokenAssertion;

public class TokenAssertionImpl
implements TokenAssertion {
    private boolean requireDerivedKey = false;
    private boolean derivedKeyOptional = false;
    private boolean requireExplicitDerivedKey = false;
    private boolean requireImplicitDerivedKey = false;
    private TokenAssertion.TokenInclusion tokenInclusion = TokenAssertion.TokenInclusion.ALWAYS;
    private String issuer = null;
    private String issuerName = null;
    private boolean optional = false;
    private boolean requireExternalReference = false;
    private boolean requireInternalReference = false;

    TokenAssertionImpl(Token token) {
        if (token.getRequireDerivedKeys() != null) {
            this.requireDerivedKey = true;
            this.derivedKeyOptional = token.getRequireDerivedKeys().isOptional();
        }
        this.requireExternalReference = token.getRequireExternalReference() != null;
        this.requireInternalReference = token.getRequireInternalReference() != null;
        this.requireImplicitDerivedKey = token.getRequireImplicitDerivedKeys() != null;
        this.requireExplicitDerivedKey = token.getRequireExplicitDerivedKeys() != null;
        this.issuer = token.getIssuerAddress();
        this.issuerName = token.getIssuerName();
        this.optional = token.isOptional();
        if (token.getTokenInclusion() == null) {
            return;
        }
        String string = token.getTokenInclusion().getInclusion();
        if (string.endsWith("/IncludeToken/AlwaysToRecipient") || string.endsWith("/AlwaysToRecipient")) {
            this.tokenInclusion = TokenAssertion.TokenInclusion.TO_RECIPIENT_ONLY;
        } else if (string.endsWith("/IncludeToken/Never")) {
            this.tokenInclusion = TokenAssertion.TokenInclusion.NEVER;
        } else if (string.endsWith("/IncludeToken/Always")) {
            this.tokenInclusion = TokenAssertion.TokenInclusion.ALWAYS;
        } else if (string.endsWith("/IncludeToken/AlwaysToInitiator")) {
            this.tokenInclusion = TokenAssertion.TokenInclusion.TO_INITIATOR_ONLY;
        } else if (string.endsWith("/IncludeToken/Once")) {
            this.tokenInclusion = TokenAssertion.TokenInclusion.ONCE;
        }
    }

    public TokenAssertion.TokenInclusion getTokenInclusion() {
        return this.tokenInclusion;
    }

    public boolean requireDerivedKey() {
        return this.requireDerivedKey;
    }

    public boolean requireExplicitDerivedKey() {
        return this.requireExplicitDerivedKey;
    }

    public boolean requireImplicitDerivedKey() {
        return this.requireImplicitDerivedKey;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean bl) {
        this.optional = bl;
    }

    public boolean isDerivedKeyOptional() {
        return this.derivedKeyOptional;
    }

    public void setDerivedKeyOptional(boolean bl) {
        this.derivedKeyOptional = bl;
    }

    public boolean isRequireInternalReference() {
        return this.requireInternalReference;
    }

    public boolean isRequireExternalReference() {
        return this.requireExternalReference;
    }
}

