/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.internal;

import weblogic.wsee.security.policy12.assertions.UsernameToken;
import weblogic.wsee.security.policy12.internal.TokenAssertionImpl;
import weblogic.wsee.security.wssp.UsernameTokenAssertion;

public class UsernameTokenAssertionImpl
extends TokenAssertionImpl
implements UsernameTokenAssertion {
    private boolean noPasswordRequried = false;
    private boolean isHashPasswordRequired = false;
    private boolean isCreatedRequired = false;
    private boolean isNonceRequired = false;
    private UsernameTokenAssertion.TokenType tokenType = UsernameTokenAssertion.TokenType.WSS_UT_10;

    UsernameTokenAssertionImpl(UsernameToken usernameToken) {
        super(usernameToken);
        this.noPasswordRequried = usernameToken.getNoPassword() != null;
        boolean bl = this.isHashPasswordRequired = usernameToken.getHashPassword() != null;
        if (this.isHashPasswordRequired) {
            this.isNonceRequired = true;
            this.isCreatedRequired = true;
        } else {
            this.isNonceRequired = usernameToken.getNonce() != null;
            boolean bl2 = this.isCreatedRequired = usernameToken.getCreated() != null;
        }
        if (usernameToken.getWssUsernameToken11() != null) {
            this.tokenType = UsernameTokenAssertion.TokenType.WSS_UT_11;
        }
    }

    public boolean noPasswordRequried() {
        return this.noPasswordRequried;
    }

    public boolean isHashPasswordRequired() {
        return this.isHashPasswordRequired;
    }

    public boolean isCreatedRequired() {
        return this.isCreatedRequired;
    }

    public boolean isNonceRequired() {
        return this.isNonceRequired;
    }

    public UsernameTokenAssertion.TokenType getUsernameTokenType() {
        return this.tokenType;
    }
}

