/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.policy12.internal;

import weblogic.wsee.security.policy12.assertions.Trust10;
import weblogic.wsee.security.policy12.assertions.Trust13;
import weblogic.wsee.security.wssp.WsTrustOptions;

public class WsTrustOptionsImpl
implements WsTrustOptions {
    private boolean isWst10 = true;
    private boolean isWst13 = false;
    private boolean isMustSupportClientChallenge = false;
    private boolean isMustSupportServerChallenge = false;
    private boolean isClientEntropyRequired = false;
    private boolean isServerEntropyRequired = false;
    private boolean isMustSupportIssuedTokens = false;
    private boolean isScopePolicy15 = false;
    private boolean isMustSupportInteractiveChallenge = false;

    WsTrustOptionsImpl(Trust10 trust10) {
        this.isMustSupportClientChallenge = trust10.getMustSupportClientChallenge() != null;
        this.isMustSupportServerChallenge = trust10.getMustSupportServerChallenge() != null;
        this.isClientEntropyRequired = trust10.getRequireClientEntropy() != null;
        this.isServerEntropyRequired = trust10.getRequireServerEntropy() != null;
        this.isMustSupportIssuedTokens = trust10.getMustSupportIssuedTokens() != null;
    }

    WsTrustOptionsImpl(Trust13 trust13) {
        this((Trust10)trust13);
        this.isWst13 = true;
        this.isWst10 = false;
        this.isScopePolicy15 = trust13.getScopePolicy15() != null;
        this.isMustSupportInteractiveChallenge = trust13.getMustSupportInteractiveChallenge() != null;
    }

    public boolean isWst10() {
        return this.isWst10;
    }

    public boolean isWst13() {
        return this.isWst13;
    }

    public boolean isMustSupportClientChallenge() {
        return this.isMustSupportClientChallenge;
    }

    public boolean isMustSupportServerChallenge() {
        return this.isMustSupportServerChallenge;
    }

    public boolean isClientEntropyRequired() {
        return this.isClientEntropyRequired;
    }

    public boolean isServerEntropyRequired() {
        return this.isServerEntropyRequired;
    }

    public boolean isMustSupportIssuedTokens() {
        return this.isMustSupportIssuedTokens;
    }

    public boolean isScopePolicy15() {
        return this.isScopePolicy15;
    }

    public boolean isMustSupportInteractiveChallenge() {
        return this.isMustSupportInteractiveChallenge;
    }
}

