/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import javax.security.auth.Subject;
import org.w3c.dom.Node;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.security.saml.CSSUtils;
import weblogic.wsee.security.saml.SAMLAttributeStatementData;
import weblogic.wsee.security.saml.SAMLIssuedTokenHelper;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.Purpose;

public abstract class AbstractSAMLCredentialProvider
implements CredentialProvider {
    private static boolean verbose = Verbose.isVerbose(AbstractSAMLCredentialProvider.class);

    public abstract String[] getValueTypes();

    public Object getCredential(String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (purpose.equals(Purpose.IDENTITY) || purpose.equals(Purpose.SIGN)) {
            boolean bl;
            if (!(contextHandler instanceof SecurityTokenContextHandler)) {
                return null;
            }
            boolean bl2 = string.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            SecurityTokenContextHandler securityTokenContextHandler = new SecurityTokenContextHandler();
            Object object = contextHandler.getValue("com.bea.contextelement.saml.CachingRequested");
            if (object != null) {
                if (verbose) {
                    Verbose.log("Requesting cached SAML assertion");
                }
                securityTokenContextHandler.addContextElement("com.bea.contextelement.saml.CachingRequested", object);
            }
            Node node = (Node)contextHandler.getValue("weblogic.xml.crypto.wss.policy.Claims");
            CSSUtils.processSAMLClaims(bl2, securityTokenContextHandler, node);
            CSSUtils.setupSAMLContextElements(bl2, securityTokenContextHandler, contextHandler);
            boolean bl3 = bl = null != contextHandler.getValue("oracle.contextelement.saml2.AttributeOnly");
            if (verbose) {
                Verbose.log("Setting SAML Attributes for attributeOnly = " + bl);
            }
            CSSUtils.setupSAMLAttributesContextElements(bl2, securityTokenContextHandler, bl, this.getSAMLAttributeData(CSSUtils.getCurrentAuthenticatedSubject()));
            Object object2 = null;
            if (CSSUtils.isHolderOfKey(bl2, securityTokenContextHandler)) {
                if (SAMLIssuedTokenHelper.isSymmetricKeyTypeFromIssuedTokenClaim(node)) {
                    object2 = this.getKeyInfoCredential(string, string2, (SecurityTokenContextHandler)contextHandler, purpose, node);
                    if (null == object2) {
                        return null;
                    }
                } else {
                    if (verbose) {
                        Verbose.log("Getting X509 KeyInfo credential");
                    }
                    object2 = this.getKeyInfoCredential(string, string2, (SecurityTokenContextHandler)contextHandler, purpose);
                }
            }
            try {
                return CSSUtils.getSAMLCredential(bl2, string, securityTokenContextHandler, object2);
            }
            catch (WSSecurityException wSSecurityException) {
                if (verbose) {
                    Verbose.log((Object)"Exception while acquiring SAML credential", wSSecurityException);
                }
                return null;
            }
        }
        return null;
    }

    public Object getKeyInfoCredential(String string, String string2, SecurityTokenContextHandler securityTokenContextHandler, Purpose purpose) {
        return CSSUtils.getX509CredFromPKICredMapper(securityTokenContextHandler);
    }

    public Object getKeyInfoCredential(String string, String string2, SecurityTokenContextHandler securityTokenContextHandler, Purpose purpose, Node node) {
        Object object = securityTokenContextHandler.getValue("com.bea.contextelement.saml.subject.dom.KeyInfo");
        if (object != null && verbose) {
            Verbose.log("Get Symmetric KeyInfo credential =" + object);
        }
        if (verbose) {
            Verbose.log("Symmetric KeyInfo credential is NOT Supported!");
        }
        return null;
    }

    public SAMLAttributeStatementData getSAMLAttributeData(Subject subject) {
        if (verbose) {
            Verbose.log("No override on getSAMLAttributeData() for SAML Attributes");
        }
        return null;
    }
}

