/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Node;
import weblogic.kernel.KernelStatus;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.saml.CSSUtils;
import weblogic.wsee.security.saml.SAMLAttributeStatementData;
import weblogic.wsee.security.saml.SAMLAttributeStatementDataFactory;
import weblogic.wsee.security.saml.SAMLCredential;
import weblogic.wsee.security.saml.SAMLCredentialImpl;
import weblogic.wsee.security.saml.SAMLKeyProvider;
import weblogic.wsee.security.saml.SAMLSecurityTokenReference;
import weblogic.wsee.security.saml.SAMLToken;
import weblogic.wsee.security.saml.SAMLTokenImpl;
import weblogic.wsee.security.wst.helpers.EncryptedKeyInfoBuilder;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.common.keyinfo.SecretKeyProvider;
import weblogic.xml.crypto.utils.CertUtils;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.SecurityTokenValidateResult;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.WSSecurityInfo;
import weblogic.xml.crypto.wss.api.KeyIdentifier;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.crypto.wss11.internal.WSS11Context;
import weblogic.xml.dom.marshal.MarshalException;
import weblogic.xml.security.utils.Utils;

public abstract class AbstractSAMLTokenHandler
implements SecurityTokenHandler {
    private static final boolean verbose = Verbose.isVerbose(AbstractSAMLTokenHandler.class);
    private static final boolean debug = false;
    private static final boolean DEBUG_SX_INTEROP_ISSUED_TOKEN = false;
    private static final boolean DEBUG_UNIT_TEST_ONLY = false;

    public abstract QName[] getQNames();

    public abstract String[] getValueTypes();

    public abstract boolean isSupportedTokenType(String var1);

    public abstract boolean isSupportedValueType(String var1);

    public abstract boolean isSaml2();

    public SecurityToken getSecurityToken(String string, Object object, ContextHandler contextHandler) throws WSSecurityException {
        return new SAMLTokenImpl(string, object);
    }

    public SecurityToken getSecurityToken(String string, String string2, Purpose purpose, ContextHandler contextHandler) throws WSSecurityException {
        WSSecurityInfo wSSecurityInfo;
        if (verbose) {
            Verbose.log("getSecurityToken for value type =" + string);
        }
        if (null == (wSSecurityInfo = (WSSecurityInfo)contextHandler.getValue("com.bea.contextelement.xml.SecurityInfo"))) {
            if (verbose) {
                Verbose.log("com.bea.contextelement.xml.SecurityInfoNot found");
            }
            return null;
        }
        List list = wSSecurityInfo.getSecurityTokens();
        if (list == null || list.size() == 0) {
            if (verbose) {
                Verbose.log("No SAML tokens from com.bea.contextelement.xml.SecurityInfo");
            }
            return null;
        }
        for (SecurityToken securityToken : list) {
            if (verbose) {
                Verbose.log("Checking Token Id = " + securityToken.getId() + " valueType = " + securityToken.getValueType() + " of " + securityToken.toString());
            }
            if (!securityToken.getValueType().equals(string)) continue;
            return securityToken;
        }
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(string)) {
            if (verbose) {
                Verbose.log("Checking again with Token Type  = http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            }
            for (SecurityToken securityToken : list) {
                if (!"http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(securityToken.getValueType())) continue;
                return securityToken;
            }
        }
        return null;
    }

    public SecurityTokenReference getSTR(QName qName, String string, SecurityToken securityToken) throws WSSecurityException {
        if (this.isSaml2() && qName.equals(WSSConstants.REFERENCE_QNAME)) {
            return new SAMLSecurityTokenReference(qName, string, securityToken);
        }
        if (!this.isSaml2() && qName.equals(WSSConstants.KEY_IDENTIFIER_QNAME)) {
            return new SAMLSecurityTokenReference(qName, string, securityToken);
        }
        return null;
    }

    public SecurityToken newSecurityToken(Node node) throws weblogic.xml.crypto.api.MarshalException {
        try {
            SAMLTokenImpl sAMLTokenImpl = new SAMLTokenImpl(new SAMLCredentialImpl(node));
            return sAMLTokenImpl;
        }
        catch (WSSecurityException wSSecurityException) {
            throw new weblogic.xml.crypto.api.MarshalException("Invalid SAML token on wsee " + wSSecurityException.getMessage(), wSSecurityException);
        }
    }

    public SecurityTokenReference newSecurityTokenReference(Node node) throws MarshalException {
        SAMLSecurityTokenReference sAMLSecurityTokenReference = new SAMLSecurityTokenReference();
        sAMLSecurityTokenReference.unmarshal(node);
        return sAMLSecurityTokenReference;
    }

    public KeyProvider getKeyProvider(SecurityToken securityToken, MessageContext messageContext) {
        if (null == securityToken) {
            return null;
        }
        SAMLToken sAMLToken = (SAMLToken)securityToken;
        if (sAMLToken.isHolderOfKey() || null != sAMLToken.getPublicKey()) {
            PublicKey publicKey = sAMLToken.getPublicKey();
            if (publicKey != null) {
                if (verbose) {
                    Verbose.log("Returning public key SAMLKeyProvider for token");
                }
                return new SAMLKeyProvider(publicKey, sAMLToken.getPrivateKey(), sAMLToken.getAssertionID(), (SecurityToken)sAMLToken);
            }
            if (null != sAMLToken.getSecretKey()) {
                Key key = sAMLToken.getSecretKey();
                if (null != key) {
                    if (verbose) {
                        Verbose.log("Returning Scret Key of SecretKeyProvider for token");
                    }
                    EncryptedKeyInfoBuilder.debugKey(key, "Got Secret Key from SAML Token");
                    return new SecretKeyProvider(key, null, sAMLToken.getAssertionID().getBytes(), (String)null, (SecurityToken)sAMLToken);
                }
            } else if (null == sAMLToken.getCredential()) {
                if (verbose) {
                    Verbose.log("Null credentail on SAML token");
                }
            } else if (sAMLToken.getCredential() instanceof SAMLCredentialImpl) {
                SAMLCredentialImpl sAMLCredentialImpl = (SAMLCredentialImpl)sAMLToken.getCredential();
                if (null != sAMLCredentialImpl.getEncryptedKeyProvider()) {
                    if (verbose) {
                        Verbose.log("Returning EncryptedKeyProvider from SAMLCredential for token");
                    }
                    return sAMLCredentialImpl.getEncryptedKeyProvider();
                }
                if (null != sAMLCredentialImpl.getSymmetircKey()) {
                    if (verbose) {
                        Verbose.log("Returning Symmetric key of SecretKeyProvider for token");
                    }
                    return new SecretKeyProvider(sAMLCredentialImpl.getSymmetircKey(), null, sAMLToken.getAssertionID().getBytes(), (String)null, (SecurityToken)sAMLToken);
                }
                if (null != sAMLCredentialImpl.getSecurityTokenReference()) {
                    SecurityTokenReference securityTokenReference = sAMLCredentialImpl.getSecurityTokenReference();
                    if (verbose) {
                        Verbose.log("Getting Keys from SecurityTokenReference in the SAML Token on HofK case for STR =" + securityTokenReference);
                    }
                    String string = securityTokenReference.getValueType();
                    String string2 = Utils.toBase64(securityTokenReference.getKeyIdentifier().getIdentifier());
                    SecurityTokenHandler securityTokenHandler = null;
                    WSS11Context wSS11Context = null;
                    try {
                        wSS11Context = (WSS11Context)messageContext.getProperty("weblogic.xml.crypto.wss.WSSecurityContext");
                        securityTokenHandler = wSS11Context.getRequiredTokenHandler(string);
                        if (null == securityTokenHandler) {
                            Verbose.log("Unable to find the SecurityTokenHandler for valueType = " + string);
                            return null;
                        }
                    }
                    catch (Exception exception) {
                        Verbose.logException(exception);
                        return null;
                    }
                    try {
                        SecurityToken securityToken2 = securityTokenHandler.getSecurityToken(securityTokenReference, messageContext);
                        if (null == securityToken2) {
                            Verbose.log("Unable to find the secToken for valueType = " + string);
                            return null;
                        }
                        return new SAMLKeyProvider(securityToken2.getPublicKey(), securityToken2.getPrivateKey(), sAMLToken.getAssertionID(), (SecurityToken)sAMLToken);
                    }
                    catch (WSSecurityException wSSecurityException) {
                        Verbose.log("Unable to find SKI=" + string2);
                        Verbose.logException(wSSecurityException);
                        System.out.println("Wrong SKI from the SAML Token, Try to get with the client key for signature again");
                        try {
                            CredentialProvider credentialProvider = wSS11Context.getRequiredCredentialProvider(string);
                            Object object = credentialProvider.getCredential(string, null, new SecurityTokenContextHandler(wSS11Context), Purpose.SIGN);
                            if (object == null) {
                                Verbose.log("Again, without SKI still unable to find the credentail for valueType = " + string);
                                return null;
                            }
                            SecurityToken securityToken3 = securityTokenHandler.getSecurityToken(string, object, new SecurityTokenContextHandler(wSS11Context));
                            if (null == securityToken3) {
                                Verbose.log("Again, without SKI still unable to find the secToken for valueType = " + string);
                                return null;
                            }
                            Verbose.log("Try again, hacker code without SKI and got the secToken for  for SAMLKeyProvider");
                            return new SAMLKeyProvider(securityToken3.getPublicKey(), securityToken3.getPrivateKey(), sAMLToken.getAssertionID(), (SecurityToken)sAMLToken);
                        }
                        catch (Exception exception) {
                            Verbose.logException(exception);
                            return null;
                        }
                    }
                    catch (Exception exception) {
                        Verbose.logException(exception);
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public SecurityToken getSecurityToken(SecurityTokenReference securityTokenReference, MessageContext messageContext) throws WSSecurityException {
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
        List list = wSSecurityContext.getSecurityTokens();
        String string = securityTokenReference.getReferenceURI();
        if (string != null && string.startsWith("#")) {
            string = string.substring(1);
        }
        KeyIdentifier keyIdentifier = securityTokenReference.getKeyIdentifier();
        for (SecurityToken securityToken : list) {
            SAMLToken sAMLToken;
            if (!(string != null ? string.equals(securityToken.getId()) : keyIdentifier != null && securityToken instanceof SAMLToken && Arrays.equals((sAMLToken = (SAMLToken)securityToken).getAssertionID().getBytes(), keyIdentifier.getIdentifier()))) continue;
            return securityToken;
        }
        throw new WSSecurityException("Failed to retrieve token for reference " + securityTokenReference, WSSConstants.FAILURE_TOKEN_UNAVAILABLE);
    }

    public SecurityTokenValidateResult validateUnmarshalled(SecurityToken securityToken, MessageContext messageContext) {
        Object object;
        SAMLToken sAMLToken = (SAMLToken)securityToken;
        SecurityTokenContextHandler securityTokenContextHandler = new SecurityTokenContextHandler();
        String string = (String)messageContext.getProperty("weblogic.wsee.connection.end_point_address");
        securityTokenContextHandler.addContextElement("com.bea.contextelement.saml.TargetResource", CSSUtils.getEndpointPath(this.isSaml2(), string));
        if (this.isSaml2()) {
            object = new ArrayList();
            securityTokenContextHandler.addContextElement("com.bea.contextelement.saml2.Attributes", object);
        } else {
            object = new ArrayList();
            securityTokenContextHandler.addContextElement("com.bea.contextelement.saml.Attributes", object);
        }
        object = "weblogic.xml.crypto.wss.provider.Purpose";
        SAMLCredential sAMLCredential = (SAMLCredential)sAMLToken.getCredential();
        if (verbose) {
            ((SAMLCredentialImpl)sAMLCredential).verbose();
            Verbose.log("Is HofK =" + sAMLToken.isHolderOfKey());
            if (null == messageContext.getProperty((String)object)) {
                Verbose.log((String)object + " is null");
            } else {
                Verbose.log((String)object + "=" + messageContext.getProperty((String)object) + " is Decryption =" + (Purpose.DECRYPT == messageContext.getProperty((String)object)));
            }
        }
        Node node = (Node)sAMLCredential.getCredential();
        if (sAMLToken.isHolderOfKey() && Purpose.DECRYPT == messageContext.getProperty((String)object)) {
            if (verbose) {
                Verbose.log("Bypass CSS Validation due to it is HofK and purpose =" + messageContext.getProperty((String)object));
            }
        } else {
            try {
                sAMLToken.setSubject(CSSUtils.assertIdentity(node, securityTokenContextHandler, this.isSaml2()).getSubject());
                if (verbose) {
                    Verbose.log("asserted identity: subject is '" + sAMLToken.getSubject() + "'");
                }
            }
            catch (Exception exception) {
                if (verbose) {
                    Verbose.log((Object)"SAML Token is rejected by CSS", exception);
                }
                return new SecurityTokenValidateResult(false, "The SAML token is not valid, it is rejected by CSS ");
            }
        }
        Object object2 = null;
        object2 = this.isSaml2() ? securityTokenContextHandler.getValue("com.bea.contextelement.saml2.Attributes") : securityTokenContextHandler.getValue("com.bea.contextelement.saml.Attributes");
        SAMLAttributeStatementData sAMLAttributeStatementData = SAMLAttributeStatementDataFactory.makeSAMLAttributeStatementData(object2);
        if (null != sAMLAttributeStatementData) {
            if (verbose) {
                Verbose.log("Saving SAMLAttributeStatementData into SAML Credential and message context ");
            }
            messageContext.setProperty("weblogic.wsee.security.saml.attributies", (Object)sAMLAttributeStatementData);
            sAMLCredential.setAttributes(sAMLAttributeStatementData);
        }
        if (sAMLToken.isHolderOfKey() && sAMLCredential.getEncryptedKey() != null) {
            try {
                EncryptedKeyInfoBuilder.processEncryptedKey(sAMLCredential, messageContext);
            }
            catch (Exception exception) {
                if (verbose) {
                    Verbose.log((Object)"Error on processing EncryptedKey element ", exception);
                }
                return new SecurityTokenValidateResult(false, "Error in processing EncryptedKey element in the SAML Token, Exception =" + exception.toString());
            }
        }
        boolean bl = true;
        X509Certificate x509Certificate = sAMLToken.getHolderOfCert();
        if (x509Certificate != null && sAMLToken.isHolderOfKey()) {
            boolean bl2 = true;
            WssPolicyContext wssPolicyContext = (WssPolicyContext)messageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
            if (wssPolicyContext != null && !wssPolicyContext.getWssConfiguration().validateHOKNeeded()) {
                bl2 = false;
            } else if (!KernelStatus.isServer()) {
                bl2 = false;
            }
            if (bl2) {
                if (verbose) {
                    Verbose.log("WssPolicyContext.WSS_POLICY_CTX_PROP is not set, validating Certificate  of " + x509Certificate.toString());
                }
                if (!(bl = CertUtils.validateCertificate(x509Certificate))) {
                    Verbose.log("Certificate is fail to validate");
                } else if (verbose) {
                    Verbose.log("WssPolicyContext.WSS_POLICY_CTX_PROP is set, or it is off-server case, bypass the validating Certificate");
                }
            }
        }
        return new SecurityTokenValidateResult(bl);
    }

    public SecurityTokenValidateResult validateProcessed(SecurityToken securityToken, MessageContext messageContext) {
        return new SecurityTokenValidateResult(true);
    }

    public boolean matches(SecurityToken securityToken, String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (securityToken == null) {
            return false;
        }
        Object object = securityToken.getCredential();
        if (object == null) {
            return false;
        }
        return object instanceof SAMLCredential && (this.isSupportedTokenType(string) || this.isSupportedValueType(string));
    }

    public Subject getSubject(SecurityToken securityToken, MessageContext messageContext) throws WSSecurityException {
        SAMLToken sAMLToken = (SAMLToken)securityToken;
        return sAMLToken.getSubject();
    }
}

