/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.security.KeyPairCredential;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.CredentialManager;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.RemoteResource;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.security.saml.SAMLAttributeStatementData;
import weblogic.wsee.security.saml.SAMLConstants;
import weblogic.wsee.security.saml.SAMLCredentialImpl;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfoFactory;
import weblogic.xml.crypto.dsig.api.keyinfo.X509Data;
import weblogic.xml.crypto.dsig.keyinfo.KeyInfoImpl;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.X509Credential;
import weblogic.xml.crypto.wss.policy.ClaimsBuilder;
import weblogic.xml.dom.DOMStreamWriter;
import weblogic.xml.dom.NamespaceUtils;

public class CSSUtils {
    private static boolean verbose = Verbose.isVerbose(CSSUtils.class);
    private static final AuthenticatedSubject kernelId = CSSUtils.getKernelID();
    private static final boolean isEnableSaml11RelativePath = Boolean.parseBoolean(System.getProperty("weblogic.wsee.security.saml.EnableSaml11RelativePathConfig"));
    private static Stack<DocumentBuilder> pool = new Stack();
    protected static final String SAML_ATTRIBUTES = "com.bea.contextelement.saml.Attributes";
    protected static final String SAML2_ATTRIBUTES = "com.bea.contextelement.saml2.Attributes";
    protected static final String SAML_ATTRIBUTE_ONLY = "com.bea.contextelement.saml.AttributeOnly";

    private static AuthenticatedSubject getKernelID() {
        return (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private static CredentialManager getCredentialManager() {
        String string = "weblogicDEFAULT";
        CredentialManager credentialManager = (CredentialManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.CREDENTIALMANAGER);
        if (credentialManager == null) {
            throw new RuntimeException("CredentialManager Unavailable");
        }
        return credentialManager;
    }

    private static PrincipalAuthenticator getPrincipalAuthenticator() {
        String string = "weblogicDEFAULT";
        PrincipalAuthenticator principalAuthenticator = SecurityServiceManager.getPrincipalAuthenticator((AuthenticatedSubject)kernelId, (String)string);
        if (principalAuthenticator == null) {
            throw new RuntimeException("PrincipalAuthenticator Unavailable");
        }
        return principalAuthenticator;
    }

    static void processSAMLClaims(boolean bl, SecurityTokenContextHandler securityTokenContextHandler, Node node) {
        if (node == null) {
            throw new IllegalArgumentException("claims of SAML token is null");
        }
        String string = ClaimsBuilder.getClaimFromElt(node, SAMLConstants.CONFIRMATION_METHOD_QNAME);
        string = bl ? CSSUtils.mapSAML2ConfMethod(string) : CSSUtils.mapSAMLConfMethod(string);
        if (string == null) {
            throw new IllegalArgumentException("ConfirmationMethod of saml token is not specified.");
        }
        if (verbose) {
            Verbose.log("Requested subject confirmation is: " + string);
        }
        securityTokenContextHandler.addContextElement("com.bea.contextelement.saml.subject.ConfirmationMethod", string);
    }

    public static void setupSAMLContextElements(boolean bl, SecurityTokenContextHandler securityTokenContextHandler, ContextHandler contextHandler) {
        String string = (String)contextHandler.getValue("com.bea.contextelement.xml.EndpointURL");
        if (bl) {
            if (verbose) {
                Verbose.log("Setting: com.bea.contextelement.saml.TargetResource to " + string);
            }
            securityTokenContextHandler.addContextElement("com.bea.contextelement.saml.TargetResource", string);
        } else {
            if (verbose) {
                Verbose.log("Setting ENDPOINT_URL and SAML_TARGET_RESOURCE to: " + string);
            }
            securityTokenContextHandler.addContextElement("com.bea.contextelement.xml.EndpointURL", string);
            securityTokenContextHandler.addContextElement("com.bea.contextelement.saml.TargetResource", string);
        }
    }

    public static void setupSAMLAttributesContextElements(boolean bl, SecurityTokenContextHandler securityTokenContextHandler, boolean bl2, SAMLAttributeStatementData sAMLAttributeStatementData) {
        if (verbose) {
            Verbose.log("Setting SAML Attributes....");
        }
        if (null == sAMLAttributeStatementData || sAMLAttributeStatementData.isEmpty()) {
            if (verbose) {
                Verbose.log("No SAML Attributes data found");
            }
            if (!bl2) {
                if (verbose) {
                    Verbose.log("Requesting a SAML Token without SAML Attributes");
                }
                return;
            }
            if (verbose) {
                Verbose.log("Requesting a SAML Token with SAML Attributes only but no attributes value");
            }
            if (verbose) {
                Verbose.log("Adding only com.bea.contextelement.saml.AttributeOnly with \"True\" into CtxHandler");
            }
            securityTokenContextHandler.addContextElement(SAML_ATTRIBUTE_ONLY, new Boolean("true"));
            if (bl) {
                ArrayList arrayList = new ArrayList();
                securityTokenContextHandler.addContextElement(SAML2_ATTRIBUTES, arrayList);
            } else {
                ArrayList arrayList = new ArrayList();
                securityTokenContextHandler.addContextElement(SAML_ATTRIBUTES, arrayList);
            }
            return;
        }
        if (bl) {
            if (verbose) {
                Verbose.log("Requesting SAML Attributes to be generated from colliction of <SAML2AttributeStatementInfo>");
            }
            securityTokenContextHandler.addContextElement(SAML2_ATTRIBUTES, sAMLAttributeStatementData.getCollectionsForSAML2AttributeStatementInfo());
        } else {
            if (verbose) {
                Verbose.log("Requesting SAML Attributes to be generated from colliction of <SAMLAttributeStatementInfo>");
            }
            securityTokenContextHandler.addContextElement(SAML_ATTRIBUTES, sAMLAttributeStatementData.getCollectionsForSAMLAttributeStatementInfo());
        }
        if (bl2) {
            if (verbose) {
                Verbose.log("Finally, requesting a SAML Token with SAML Attributes only");
            }
            if (verbose) {
                Verbose.log("Adding com.bea.contextelement.saml.AttributeOnly with \"True\" into CtxHandler");
            }
            securityTokenContextHandler.addContextElement(SAML_ATTRIBUTE_ONLY, new Boolean("true"));
        }
    }

    public static Object getSAMLCredential(boolean bl, String string, SecurityTokenContextHandler securityTokenContextHandler, Object object) throws WSSecurityException {
        return CSSUtils.getSAMLCredential(bl, string, securityTokenContextHandler, object, null);
    }

    public static Object getSAMLCredential(boolean bl, String string, SecurityTokenContextHandler securityTokenContextHandler, Object object, AuthenticatedSubject authenticatedSubject) throws WSSecurityException {
        Object object2;
        Object object3;
        PrivateKey privateKey = null;
        if (object != null) {
            object3 = null;
            if (object instanceof X509Credential) {
                object2 = (X509Credential)object;
                ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
                arrayList.add(((X509Credential)object2).getCertificate());
                object3 = CSSUtils.getKeyInfoNodeFromCerts(arrayList);
                privateKey = ((X509Credential)object2).getPrivateKey();
                if (object3 != null) {
                    if (verbose) {
                        Verbose.log("Adding KeyInfo element to context handler: " + object3);
                    }
                    securityTokenContextHandler.addContextElement("com.bea.contextelement.saml.subject.dom.KeyInfo", object3);
                } else if (verbose) {
                    Verbose.log("Null KeyInfo element from X509 cert is NOT added to context handler ");
                }
            } else if (object instanceof Node) {
                object3 = (Node)object;
                if (verbose) {
                    Verbose.log("Adding KeyInfo Node to context handler fot SAML assertion: [" + DOMUtils.toXMLString((Node)object3) + "]");
                }
                securityTokenContextHandler.addContextElement("com.bea.contextelement.saml.subject.dom.KeyInfo", object3);
            } else if (verbose) {
                Verbose.log("Not supported Key Info type found! NO ACTION");
            }
        }
        object3 = null;
        object3 = bl ? CSSUtils.getSAMLAssertionFromCredMapper(securityTokenContextHandler, "SAML2.Assertion.DOM", authenticatedSubject) : CSSUtils.getSAMLAssertionFromCredMapper(securityTokenContextHandler, "SAML.Assertion.DOM", authenticatedSubject);
        if (object3 != null && ((Object[])object3).length > 0 && object3[0] instanceof Element) {
            object2 = (Element)object3[0];
            if (verbose) {
                Verbose.log("Returning new SAML Assertion from CSS for CredentialImpl: [" + DOMUtils.toXMLString((Node)object2) + "]");
            }
            return new SAMLCredentialImpl(string, object2, privateKey);
        }
        if (verbose) {
            Verbose.log("Didn't get assertion, returning null credential");
        }
        return null;
    }

    public static boolean isHolderOfKey(boolean bl, SecurityTokenContextHandler securityTokenContextHandler) {
        String string = (String)securityTokenContextHandler.getValue("com.bea.contextelement.saml.subject.ConfirmationMethod");
        if (bl) {
            return string != null && string.equals("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        }
        return string != null && string.equals("holder-of-key");
    }

    public static boolean isHolderOfKey(String string) {
        return "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(string) || "holder-of-key".equals(string) || "HOLDER_OF_KEY".equals(string);
    }

    public static Subject getCurrentAuthenticatedSubject() {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        return authenticatedSubject.getSubject();
    }

    public static X509Credential getX509CredFromPKICredMapper(SecurityTokenContextHandler securityTokenContextHandler) {
        CredentialManager credentialManager = CSSUtils.getCredentialManager();
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        RemoteResource remoteResource = CSSUtils.getRemoteResource(securityTokenContextHandler);
        if (remoteResource == null) {
            return null;
        }
        Object[] objectArray = credentialManager.getCredentials(kernelId, authenticatedSubject, (Resource)remoteResource, (ContextHandler)securityTokenContextHandler, "weblogic.pki.Keypair");
        if (objectArray == null || objectArray.length == 0) {
            if (verbose) {
                Verbose.log("can't find holder-of-key from PKICreditMapper");
            }
            return null;
        }
        KeyPairCredential keyPairCredential = (KeyPairCredential)objectArray[0];
        return new X509Credential((X509Certificate)keyPairCredential.getCertificate(), (PrivateKey)keyPairCredential.getKey());
    }

    public static Object[] getSAMLAssertionFromCredMapper(SecurityTokenContextHandler securityTokenContextHandler, String string) {
        return CSSUtils.getSAMLAssertionFromCredMapper(securityTokenContextHandler, string, null);
    }

    public static Object[] getSAMLAssertionFromCredMapper(SecurityTokenContextHandler securityTokenContextHandler, String string, AuthenticatedSubject authenticatedSubject) {
        CredentialManager credentialManager = CSSUtils.getCredentialManager();
        if (authenticatedSubject == null) {
            authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        }
        if (verbose) {
            Verbose.log("Calling CSS for subject " + authenticatedSubject.toString() + " and token type " + string);
        }
        return credentialManager.getCredentials(kernelId, authenticatedSubject, null, (ContextHandler)securityTokenContextHandler, string);
    }

    static RemoteResource getRemoteResource(SecurityTokenContextHandler securityTokenContextHandler) {
        String string = (String)securityTokenContextHandler.getValue("com.bea.contextelement.xml.EndpointURL");
        URL uRL = null;
        try {
            if (string == null) {
                return null;
            }
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (verbose) {
                Verbose.log((Object)"Failed to resolve remote target URL", malformedURLException);
            }
            return null;
        }
        RemoteResource remoteResource = new RemoteResource(uRL.getProtocol(), uRL.getHost(), String.valueOf(uRL.getPort()), uRL.getPath(), null);
        return remoteResource;
    }

    public static AuthenticatedSubject assertIdentity(Node node, ContextHandler contextHandler, boolean bl) throws LoginException {
        String string;
        if (verbose) {
            Verbose.log("Attempting assertIdentity");
        }
        if (verbose) {
            Verbose.log("SAML_TARGET_RESOURCE is: " + contextHandler.getValue("com.bea.contextelement.saml.TargetResource"));
        }
        PrincipalAuthenticator principalAuthenticator = CSSUtils.getPrincipalAuthenticator();
        if (verbose) {
            Verbose.log("Got Principal Authenticator");
        }
        Document document = CSSUtils.getParser().newDocument();
        Node node2 = document.importNode(node, true);
        document.appendChild(node2);
        String string2 = string = bl ? "SAML2.Assertion.DOM" : "SAML.Assertion.DOM";
        if (verbose) {
            Verbose.log("Cred type is: " + string + ", Node: " + node2);
        }
        AuthenticatedSubject authenticatedSubject = null;
        try {
            authenticatedSubject = principalAuthenticator.assertIdentity(string, (Object)node2, contextHandler);
        }
        catch (LoginException loginException) {
            if (verbose) {
                Verbose.log("Exception while asserting identity: " + loginException.toString());
            }
            if (verbose) {
                Verbose.log(loginException);
            }
            throw loginException;
        }
        if (verbose) {
            Verbose.log("Got subject: " + authenticatedSubject);
        }
        return authenticatedSubject;
    }

    private static DocumentBuilder createNewParser() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RuntimeException(factoryConfigurationError);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DocumentBuilder getParser() {
        DocumentBuilder documentBuilder = null;
        Stack<DocumentBuilder> stack = pool;
        synchronized (stack) {
            documentBuilder = pool.empty() ? CSSUtils.createNewParser() : pool.pop();
        }
        return documentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void returnParser(DocumentBuilder documentBuilder) {
        Stack<DocumentBuilder> stack = pool;
        synchronized (stack) {
            pool.push(documentBuilder);
        }
    }

    private static Node getKeyInfoNodeFromCerts(List list) {
        try {
            XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance();
            KeyInfoFactory keyInfoFactory = xMLSignatureFactory.getKeyInfoFactory();
            X509Data x509Data = keyInfoFactory.newX509Data(list);
            KeyInfoImpl keyInfoImpl = (KeyInfoImpl)keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
            Document document = CSSUtils.getParser().newDocument();
            DOMStreamWriter dOMStreamWriter = new DOMStreamWriter(document);
            keyInfoImpl.write((XMLStreamWriter)((Object)dOMStreamWriter));
            Node node = document.getFirstChild();
            CSSUtils.declarePrefixOnKeyInfoNode(node);
            return node;
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException(xMLSignatureException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new RuntimeException(xMLStreamException);
        }
        catch (MarshalException marshalException) {
            throw new RuntimeException(marshalException);
        }
    }

    private static void declarePrefixOnKeyInfoNode(Node node) {
        Object object;
        if (node.getNodeType() == 1 && ((object = node.getPrefix()) == null || ((String)object).length() == 0)) {
            node.setPrefix("dsig");
            NamespaceUtils.defineNamespace((Element)((Element)node), (String)"dsig", (String)"http://www.w3.org/2000/09/xmldsig#");
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            CSSUtils.declarePrefixOnKeyInfoNode(object.item(i));
        }
    }

    protected static String getEndpointPath(boolean bl, String string) {
        if (bl || isEnableSaml11RelativePath) {
            try {
                URL uRL = new URL(string);
                return uRL.getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return string;
    }

    protected static String mapSAML2ConfMethod(String string) {
        if ("bearer".equals(string) || "BEARER".equals(string)) {
            return "urn:oasis:names:tc:SAML:2.0:cm:bearer";
        }
        if ("sender-vouches".equals(string) || "SENDER_VOUCHES".equals(string)) {
            return "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
        }
        if ("holder-of-key".equals(string) || "HOLDER_OF_KEY".equals(string)) {
            return "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
        }
        if (verbose) {
            Verbose.log("Unable to map the SAML 2.0 confirmation method on: [" + string + "]");
        }
        return null;
    }

    protected static String mapSAMLConfMethod(String string) {
        if ("bearer".equals(string) || "BEARER".equals(string)) {
            return "bearer";
        }
        if ("sender-vouches".equals(string) || "SENDER_VOUCHES".equals(string)) {
            return "sender-vouches";
        }
        if ("holder-of-key".equals(string) || "HOLDER_OF_KEY".equals(string)) {
            return "holder-of-key";
        }
        if (verbose) {
            Verbose.log("Unable to map the SAML 1.1 confirmation method on: [" + string + "]");
        }
        return null;
    }
}

