/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import weblogic.security.utils.SAMLAssertionInfo;
import weblogic.wsee.security.saml.CSSUtils;

public class SAMLAssertionInfoImpl
implements SAMLAssertionInfo {
    private static final String SAML_ASSERTION_TAG = "Assertion";
    private static final String SAML11_ID_ATTR = "AssertionID";
    private static final String SAML11_VERSION = "1.1";
    private static final String SAML20_ID_ATTR = "ID";
    private static final String SAML20_VERSION = "2.0";
    private static final String SAML_ISSUER_ATTR = "Issuer";
    private static final String SAML_CONDITIONS_TAG = "Conditions";
    private static final String SAML_NOTBEFORE_ATTR = "NotBefore";
    private static final String SAML_NOTONORAFTER_ATTR = "NotOnOrAfter";
    private static final String SAML_SUBJECT_TAG = "Subject";
    private static final String SAML_ATN_STATEMENT_TAG = "AuthenticationStatement";
    private static final String SAML_ATTRIBUTE_STATEMENT_TAG = "AttributeStatement";
    private static final String SAML11_NAMEID_TAG = "NameIdentifier";
    private static final String SAML20_NAMEID_TAG = "NameID";
    private static final String SAML_SUBJCONF_TAG = "SubjectConfirmation";
    private static final String SAML20_SUBJCONF_METHOD_ATTR = "Method";
    private static final String SAML11_SUBJCONF_METHOD_TAG = "ConfirmationMethod";
    private static final String SAML_KEYINFO_TAG = "KeyInfo";
    private static final String SAML_SUBJCONF_DATA_TAG = "SubjectConfirmationData";
    private static final String SAML_SIGNATURE_TAG = "Signature";
    Element _assertion = null;
    String _version = null;
    boolean _isVersion20Assertion = true;
    String _id = null;
    String _issuer = null;
    String _subject = null;
    String _confirmation = null;
    Date _notBefore = null;
    Date _notOnOrAfter = null;
    Element _keyInfo = null;
    Element _issuerKeyInfo = null;

    SAMLAssertionInfoImpl(Element element) {
        this.init(element);
    }

    SAMLAssertionInfoImpl(String string) {
        try {
            Element element = this.parseAssertion(string);
            this.init(element);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid assertion xml: failed to parse", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element parseAssertion(String string) throws SAXException, IOException {
        Element element;
        block2: {
            DocumentBuilder documentBuilder = null;
            try {
                documentBuilder = CSSUtils.getParser();
                Document document = documentBuilder.parse(string);
                element = document.getDocumentElement();
                Object var6_5 = null;
                if (documentBuilder == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (documentBuilder == null) break block3;
                    CSSUtils.returnParser(documentBuilder);
                }
                throw throwable;
            }
            CSSUtils.returnParser(documentBuilder);
        }
        return element;
    }

    private void init(Element element) {
        this._assertion = element;
        if (!SAML_ASSERTION_TAG.equals(this._assertion.getLocalName())) {
            throw new IllegalArgumentException("DOM Element is not an assertion");
        }
        this._version = this._assertion.getAttribute("Version");
        if (this._version == null || !this._version.equals(SAML20_VERSION)) {
            String string = this._assertion.getAttribute("MajorVersion");
            String string2 = this._assertion.getAttribute("MinorVersion");
            this._version = string + "." + string2;
            if (this._version == null || !this._version.equals(SAML11_VERSION)) {
                throw new IllegalArgumentException("DOM Element does not have a valid SAML version");
            }
            this._isVersion20Assertion = false;
        }
        this._id = this._isVersion20Assertion ? this._assertion.getAttribute(SAML20_ID_ATTR) : this._assertion.getAttribute(SAML11_ID_ATTR);
        this._issuer = this._assertion.getAttribute(SAML_ISSUER_ATTR);
        this.initConditions();
        this.initSubject();
        this._issuerKeyInfo = SAMLAssertionInfoImpl.getKeyInfoFromIssuer(this._assertion);
    }

    private void initConditions() {
        Element element = SAMLAssertionInfoImpl.getFirstMatchingChildElement(this._assertion, SAML_CONDITIONS_TAG);
        if (element != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            try {
                this._notBefore = simpleDateFormat.parse(element.getAttribute(SAML_NOTBEFORE_ATTR));
                this._notOnOrAfter = simpleDateFormat.parse(element.getAttribute(SAML_NOTONORAFTER_ATTR));
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("Unable to parse conditions", parseException);
            }
            return;
        }
    }

    private void initSubject() {
        Element element = this.getSubjectFromAssertion(this._assertion);
        if (element == null) {
            throw new IllegalArgumentException("No Subject in assertion");
        }
        this._subject = this.getNameFromSubject(element);
        this._confirmation = this.getConfirmationFromSubject(element);
        this._keyInfo = this.getKeyInfoFromSubject(element);
    }

    private Element getSubjectFromAssertion(Element element) {
        if (this._isVersion20Assertion) {
            return SAMLAssertionInfoImpl.getFirstMatchingChildElement(element, SAML_SUBJECT_TAG);
        }
        Element element2 = SAMLAssertionInfoImpl.getFirstMatchingChildElement(element, SAML_ATN_STATEMENT_TAG);
        if (element2 != null) {
            return SAMLAssertionInfoImpl.getFirstMatchingChildElement(element2, SAML_SUBJECT_TAG);
        }
        element2 = SAMLAssertionInfoImpl.getFirstMatchingChildElement(element, SAML_ATTRIBUTE_STATEMENT_TAG);
        if (element2 != null) {
            return SAMLAssertionInfoImpl.getFirstMatchingChildElement(element2, SAML_SUBJECT_TAG);
        }
        return null;
    }

    private String getNameFromSubject(Element element) {
        Element element2 = SAMLAssertionInfoImpl.getFirstMatchingChildElement(element, this._isVersion20Assertion ? SAML20_NAMEID_TAG : SAML11_NAMEID_TAG);
        return this.getElementText(element2);
    }

    private static Element getFirstMatchingChildElement(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getLocalName().equals(string)) continue;
            return (Element)node;
        }
        return null;
    }

    private String getConfirmationFromSubject(Element element) {
        Element element2 = SAMLAssertionInfoImpl.getFirstMatchingChildElement(element, SAML_SUBJCONF_TAG);
        if (element2 != null) {
            if (this._isVersion20Assertion) {
                return element2.getAttribute(SAML20_SUBJCONF_METHOD_ATTR);
            }
            Element element3 = SAMLAssertionInfoImpl.getFirstMatchingChildElement(element2, SAML11_SUBJCONF_METHOD_TAG);
            return this.getElementText(element3);
        }
        return null;
    }

    private Element getKeyInfoFromSubject(Element element) {
        Element element2 = SAMLAssertionInfoImpl.getFirstMatchingChildElement(element, SAML_SUBJCONF_TAG);
        if (this._confirmation != null && element2 != null) {
            if (this._isVersion20Assertion && this._confirmation.equals("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key")) {
                Element element3 = SAMLAssertionInfoImpl.getFirstMatchingChildElement(element2, SAML_SUBJCONF_DATA_TAG);
                if (element3 != null) {
                    return SAMLAssertionInfoImpl.getFirstMatchingChildElement(element3, SAML_KEYINFO_TAG);
                }
            } else if (!this._isVersion20Assertion && this._confirmation.equals("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key")) {
                return SAMLAssertionInfoImpl.getFirstMatchingChildElement(element2, SAML_KEYINFO_TAG);
            }
        }
        return null;
    }

    private static Element getKeyInfoFromIssuer(Element element) {
        Element element2 = SAMLAssertionInfoImpl.getFirstMatchingChildElement(element, SAML_SIGNATURE_TAG);
        if (null == element2) {
            return null;
        }
        return SAMLAssertionInfoImpl.getFirstMatchingChildElement(element2, SAML_KEYINFO_TAG);
    }

    private String getElementText(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            return node.getNodeValue();
        }
        return null;
    }

    public String getId() {
        return this._id;
    }

    public String getSubjectName() {
        return this._subject;
    }

    public String getSubjectConfirmationMethod() {
        return this._confirmation;
    }

    public Element getSubjectKeyInfo() {
        return this._keyInfo;
    }

    public String getVersion() {
        return this._version;
    }

    public Date getNotBefore() {
        return this._notBefore;
    }

    public Date getNotOnOrAfter() {
        return this._notOnOrAfter;
    }

    public Element getSamlAssertionSignatureKeyInfoElement() {
        return this._issuerKeyInfo;
    }

    public static Element getSamlAssertionSignatureKeyInfoElement(Element element) {
        if (null == element) {
            return null;
        }
        return SAMLAssertionInfoImpl.getKeyInfoFromIssuer(element);
    }
}

