/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import com.bea.security.saml2.providers.SAML2AttributeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import weblogic.security.providers.saml.SAMLAttributeInfo;
import weblogic.wsee.security.saml.SAMLAttributeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLAttributeDataImpl
implements SAMLAttributeData {
    public static final String SAML_2_0_ATTRNAME_FORMAT_BASIC = "urn:oasis:names:tc:SAML:2.0:attrname-format:basic";
    private String attributeName;
    private String attributeNameSpace;
    private String attributeNameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:basic";
    private String attributeFriendlyName;
    private Collection<String> attributeValues;
    private boolean isSAML20;

    public SAMLAttributeDataImpl() {
    }

    public SAMLAttributeDataImpl(String string, Collection<String> collection) {
        this.attributeName = string;
        this.attributeValues = collection;
    }

    public SAMLAttributeDataImpl(String string, String string2, String string3, String string4, Collection<String> collection) {
        this.attributeName = string;
        this.attributeNameFormat = string2;
        this.attributeFriendlyName = string3;
        this.attributeValues = collection;
        this.attributeNameSpace = string4;
    }

    public SAMLAttributeDataImpl(SAML2AttributeInfo sAML2AttributeInfo) {
        if (null == sAML2AttributeInfo) {
            throw new IllegalArgumentException("Null SAML2AttributeInfo found ");
        }
        this.attributeName = sAML2AttributeInfo.getAttributeName();
        this.attributeNameFormat = sAML2AttributeInfo.getAttributeNameFormat();
        this.attributeFriendlyName = sAML2AttributeInfo.getAttributeFriendlyName();
        this.attributeValues = sAML2AttributeInfo.getAttributeValues();
        this.isSAML20 = true;
    }

    public SAMLAttributeDataImpl(SAMLAttributeInfo sAMLAttributeInfo) {
        if (null == sAMLAttributeInfo) {
            throw new IllegalArgumentException("Null SAMLAttributeInfo found ");
        }
        this.attributeName = sAMLAttributeInfo.getAttributeName();
        this.attributeNameSpace = sAMLAttributeInfo.getAttributeNamespace();
        this.attributeValues = sAMLAttributeInfo.getAttributeValues();
        this.isSAML20 = false;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public void setAttributeName(String string) {
        if (null == string) {
            throw new IllegalArgumentException("attributeName cannot be null");
        }
        this.attributeName = string;
    }

    @Override
    public String getAttributeNameFormat() {
        return this.attributeNameFormat;
    }

    @Override
    public void setAttributeNameFormat(String string) {
        this.attributeNameFormat = string;
    }

    @Override
    public String getAttributeFriendlyName() {
        return this.attributeFriendlyName;
    }

    @Override
    public void setAttributeFriendlyName(String string) {
        this.attributeFriendlyName = string;
    }

    @Override
    public Collection<String> getAttributeValues() {
        return this.attributeValues;
    }

    @Override
    public void setAttributeValues(Collection<String> collection) {
        this.attributeValues = collection;
    }

    @Override
    public void addAttributeValue(String string) {
        if (this.attributeValues == null) {
            this.attributeValues = new ArrayList<String>();
        }
        if (null == string) {
            this.attributeValues.add("");
        } else {
            this.attributeValues.add(string);
        }
    }

    @Override
    public void addAttributeValues(Collection<String> collection) {
        if (this.attributeValues == null || this.attributeValues.isEmpty()) {
            this.setAttributeValues(collection);
            return;
        }
        if (null == collection || collection.isEmpty()) {
            this.attributeValues.add("");
            return;
        }
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.attributeValues.add(iterator.next());
        }
    }

    @Override
    public String getAttributeNameSpace() {
        return this.attributeNameSpace;
    }

    @Override
    public void setAttributeNameSpace(String string) {
        this.attributeNameSpace = string;
    }

    public void setSAML20(boolean bl) {
        this.isSAML20 = bl;
    }

    @Override
    public boolean isSAML20() {
        return this.isSAML20;
    }

    @Override
    public SAML2AttributeInfo getSAML2AttributeInfo() {
        SAML2AttributeInfo sAML2AttributeInfo = new SAML2AttributeInfo();
        sAML2AttributeInfo.setAttributeFriendlyName(this.attributeFriendlyName);
        sAML2AttributeInfo.setAttributeName(this.attributeName);
        if (null == this.attributeNameFormat || this.attributeNameFormat.length() == 0) {
            sAML2AttributeInfo.setAttributeNameFormat(SAML_2_0_ATTRNAME_FORMAT_BASIC);
        } else {
            sAML2AttributeInfo.setAttributeNameFormat(this.attributeNameFormat);
        }
        sAML2AttributeInfo.addAttributeValues(this.attributeValues);
        return sAML2AttributeInfo;
    }

    @Override
    public SAMLAttributeInfo getSAMLAttributeInfo() {
        SAMLAttributeInfo sAMLAttributeInfo = new SAMLAttributeInfo();
        if (null == this.attributeNameSpace) {
            sAMLAttributeInfo.setAttributeName(this.attributeName, "");
        } else {
            sAMLAttributeInfo.setAttributeName(this.attributeName, this.attributeNameSpace);
        }
        sAMLAttributeInfo.setAttributeValues(this.attributeValues);
        return sAMLAttributeInfo;
    }

    public static SAMLAttributeData consolation(List<SAMLAttributeData> list) {
        if (null == list || list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            list.get(0);
        }
        SAMLAttributeData sAMLAttributeData = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            sAMLAttributeData.addAttributeValues(list.get(i).getAttributeValues());
        }
        return sAMLAttributeData;
    }

    @Override
    public boolean isEmpty() {
        Object[] objectArray;
        if (null == this.attributeValues || this.attributeValues.isEmpty()) {
            return true;
        }
        return this.attributeValues.size() == 1 && "".equals((objectArray = this.attributeValues.toArray())[0]);
    }

    public String valuesToString(String string) {
        if (null == this.attributeValues || this.attributeValues.isEmpty()) {
            return string;
        }
        Object[] objectArray = this.attributeValues.toArray();
        if (this.attributeValues.size() == 1) {
            if (objectArray[0] == null) {
                return string;
            }
            if (string == null) {
                return (String)objectArray[0];
            }
            return string + "; " + (String)objectArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append("; ");
            if (objectArray[i] == null) continue;
            stringBuffer.append((String)objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Name=" + this.attributeName);
        if (this.isSAML20()) {
            if (null != this.attributeFriendlyName) {
                stringBuffer.append(" FriendlyName=" + this.attributeFriendlyName);
            }
        } else if (null != this.attributeNameSpace) {
            stringBuffer.append(" Namespace=" + this.attributeNameSpace);
        }
        if (null != (string = this.valuesToString(null))) {
            stringBuffer.append(" Value=" + string);
        }
        return stringBuffer.toString();
    }
}

