/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import com.bea.security.saml2.providers.SAML2AttributeInfo;
import com.bea.security.saml2.providers.SAML2AttributeStatementInfo;
import java.util.Collection;
import java.util.Iterator;
import weblogic.security.providers.saml.SAMLAttributeInfo;
import weblogic.security.providers.saml.SAMLAttributeStatementInfo;
import weblogic.wsee.security.saml.SAMLAttributeDataImpl;
import weblogic.wsee.security.saml.SAMLAttributeStatementData;
import weblogic.wsee.security.saml.SAMLAttributeStatementDataImpl;
import weblogic.wsee.util.Verbose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLAttributeStatementDataFactory {
    private static boolean verbose = Verbose.isVerbose(SAMLAttributeStatementDataFactory.class);

    public static SAMLAttributeStatementData makeSAMLAttributeStatementData(Object object) {
        if (null == object) {
            return null;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                if (verbose) {
                    Verbose.log("Empty SAML Attributes collection found");
                }
                return null;
            }
            Object object2 = collection.toArray()[0];
            if (object2 instanceof SAML2AttributeStatementInfo) {
                return SAMLAttributeStatementDataFactory.makeSAMLAttributeStatementDataFromSAML2AttributeStatementInfo(collection);
            }
            if (object2 instanceof SAMLAttributeStatementInfo) {
                return SAMLAttributeStatementDataFactory.makeSAMLAttributeStatementDataFromSAMLAttributeStatementInfo(collection);
            }
            if (verbose) {
                Verbose.log("Unknow SAML Attributes collection object found" + object2.toString());
            }
        }
        return null;
    }

    public static SAMLAttributeStatementData makeSAMLAttributeStatementDataFromSAML2AttributeStatementInfo(Collection<SAML2AttributeStatementInfo> collection) {
        Iterator<SAML2AttributeStatementInfo> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            if (verbose) {
                Verbose.log("Empty SAML2AttributeStatementInfo collection found for SAML Attributes 2.0");
            }
            return null;
        }
        SAML2AttributeStatementInfo sAML2AttributeStatementInfo = iterator.next();
        if (sAML2AttributeStatementInfo.getAttributeInfo() == null || sAML2AttributeStatementInfo.getAttributeInfo().isEmpty()) {
            if (verbose) {
                Verbose.log("No AttributeInfo or empty AttributeInfo on SAML2AttributeStatementInfo found on SAML Attributes 2.0");
            }
            return null;
        }
        SAMLAttributeStatementDataImpl sAMLAttributeStatementDataImpl = new SAMLAttributeStatementDataImpl();
        Iterator iterator2 = sAML2AttributeStatementInfo.getAttributeInfo().iterator();
        while (iterator2.hasNext()) {
            sAMLAttributeStatementDataImpl.addAttributeInfo(new SAMLAttributeDataImpl((SAML2AttributeInfo)iterator2.next()));
        }
        if (verbose) {
            Verbose.log("Building SAMLAttributeStatementData for SAML Attributes 2.0, size =" + sAMLAttributeStatementDataImpl.size());
        }
        return sAMLAttributeStatementDataImpl;
    }

    public static SAMLAttributeStatementData makeSAMLAttributeStatementDataFromSAMLAttributeStatementInfo(Collection<SAMLAttributeStatementInfo> collection) {
        Iterator<SAMLAttributeStatementInfo> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            if (verbose) {
                Verbose.log("Empty SAMLAttributeStatementInfo collection found for SAML Attributes 1.1");
            }
            return null;
        }
        SAMLAttributeStatementInfo sAMLAttributeStatementInfo = iterator.next();
        if (sAMLAttributeStatementInfo.getAttributeInfo() == null || sAMLAttributeStatementInfo.getAttributeInfo().isEmpty()) {
            if (verbose) {
                Verbose.log("No AttributeInfo or empty AttributeInfo on SAMLAttributeStatementInfo found on SAML Attributes 1.1");
            }
            return null;
        }
        SAMLAttributeStatementDataImpl sAMLAttributeStatementDataImpl = new SAMLAttributeStatementDataImpl();
        Iterator iterator2 = sAMLAttributeStatementInfo.getAttributeInfo().iterator();
        while (iterator2.hasNext()) {
            sAMLAttributeStatementDataImpl.addAttributeInfo(new SAMLAttributeDataImpl((SAMLAttributeInfo)iterator2.next()));
        }
        if (verbose) {
            Verbose.log("Building SAMLAttributeStatementData for SAML Attributes 1.1, size =" + sAMLAttributeStatementDataImpl.size());
        }
        return sAMLAttributeStatementDataImpl;
    }
}

