/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import com.bea.security.saml2.providers.SAML2AttributeStatementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.security.providers.saml.SAMLAttributeStatementInfo;
import weblogic.wsee.security.saml.SAMLAttributeData;
import weblogic.wsee.security.saml.SAMLAttributeDataImpl;
import weblogic.wsee.security.saml.SAMLAttributeStatementData;
import weblogic.wsee.util.Verbose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLAttributeStatementDataImpl
implements SAMLAttributeStatementData {
    private static boolean verbose = Verbose.isVerbose(SAMLAttributeStatementDataImpl.class);
    private boolean isAttributeOnlyRequest = false;
    private Collection<SAMLAttributeData> attributeData;

    public SAMLAttributeStatementDataImpl() {
        this.initAttributeInfo();
    }

    private void initAttributeInfo() {
        if (null == this.attributeData) {
            this.attributeData = new ArrayList<SAMLAttributeData>();
        }
    }

    public SAMLAttributeStatementDataImpl(Collection<SAMLAttributeData> collection) {
        this.initAttributeInfo();
        this.attributeData.addAll(collection);
    }

    @Override
    public void addAttributeInfo(SAMLAttributeData sAMLAttributeData) {
        this.initAttributeInfo();
        this.attributeData.add(sAMLAttributeData);
    }

    @Override
    public void addAttributeInfo(Collection<SAMLAttributeData> collection) {
        this.initAttributeInfo();
        this.attributeData.addAll(collection);
    }

    @Override
    public Collection<SAMLAttributeData> getAttributeInfo() {
        return this.attributeData;
    }

    @Override
    public boolean isAttributeOnlyRequest() {
        return this.isAttributeOnlyRequest;
    }

    @Override
    public void setAttributeOnlyRequest(boolean bl) {
        this.isAttributeOnlyRequest = bl;
    }

    @Override
    public boolean isEmpty() {
        if (this.attributeData == null) {
            return true;
        }
        return this.attributeData.isEmpty();
    }

    @Override
    public int size() {
        if (this.attributeData == null) {
            return 0;
        }
        return this.attributeData.size();
    }

    @Override
    public SAMLAttributeData getAttributeInfo(String string) {
        if (null == string || null == this.attributeData || this.attributeData.isEmpty()) {
            return null;
        }
        Iterator<SAMLAttributeData> iterator = this.attributeData.iterator();
        ArrayList<SAMLAttributeData> arrayList = new ArrayList<SAMLAttributeData>();
        while (iterator.hasNext()) {
            SAMLAttributeData sAMLAttributeData = iterator.next();
            if (!string.equals(sAMLAttributeData.getAttributeName())) continue;
            arrayList.add(sAMLAttributeData);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (SAMLAttributeData)arrayList.get(0);
        }
        return SAMLAttributeDataImpl.consolation(arrayList);
    }

    @Override
    public boolean hasAttributeInfo(String string) {
        if (null == string) {
            return null == this.attributeData || this.attributeData.isEmpty();
        }
        for (SAMLAttributeData sAMLAttributeData : this.attributeData) {
            if (!string.equals(sAMLAttributeData.getAttributeName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAttributeValue(String string, String string2) {
        if (null == string) {
            return null == this.attributeData || this.attributeData.isEmpty();
        }
        for (SAMLAttributeData sAMLAttributeData : this.attributeData) {
            if (!string.equals(sAMLAttributeData.getAttributeName())) continue;
            if (string2 == null && sAMLAttributeData.isEmpty()) {
                return true;
            }
            if (sAMLAttributeData.isEmpty()) continue;
            for (String string3 : sAMLAttributeData.getAttributeValues()) {
                if (!string2.equals(string3)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<SAML2AttributeStatementInfo> getCollectionsForSAML2AttributeStatementInfo() {
        if (null == this.attributeData || this.attributeData.isEmpty()) {
            if (verbose) {
                Verbose.log("No SAML Attributes found on SAMLAttributeStatementData");
            }
            return null;
        }
        if (verbose) {
            Verbose.log("Generating a colliction of <SAML2AttributeStatementInfo> for SAML 2.0 with size = " + this.attributeData.size());
        }
        SAML2AttributeStatementInfo sAML2AttributeStatementInfo = new SAML2AttributeStatementInfo();
        for (SAMLAttributeData object2 : this.attributeData) {
            sAML2AttributeStatementInfo.addAttributeInfo(object2.getSAML2AttributeInfo());
        }
        ArrayList<SAML2AttributeStatementInfo> arrayList = new ArrayList<SAML2AttributeStatementInfo>();
        arrayList.add(sAML2AttributeStatementInfo);
        return arrayList;
    }

    @Override
    public Collection<SAMLAttributeStatementInfo> getCollectionsForSAMLAttributeStatementInfo() {
        if (null == this.attributeData || this.attributeData.isEmpty()) {
            if (verbose) {
                Verbose.log("No SAML Attributes found on SAMLAttributeStatementData");
            }
            return null;
        }
        if (verbose) {
            Verbose.log("Generating a colliction of <SAMLAttributeStatementInfo> for SAML 1.1 with size = " + this.attributeData.size());
        }
        SAMLAttributeStatementInfo sAMLAttributeStatementInfo = new SAMLAttributeStatementInfo();
        for (SAMLAttributeData object2 : this.attributeData) {
            sAMLAttributeStatementInfo.addAttributeInfo(object2.getSAMLAttributeInfo());
        }
        ArrayList<SAMLAttributeStatementInfo> arrayList = new ArrayList<SAMLAttributeStatementInfo>();
        arrayList.add(sAMLAttributeStatementInfo);
        return arrayList;
    }

    public Map<String, String> getNameValuePair() {
        if (this.isEmpty()) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (SAMLAttributeData sAMLAttributeData : this.attributeData) {
            String string = (String)hashMap.get(sAMLAttributeData.getAttributeName());
            hashMap.put(sAMLAttributeData.getAttributeName(), ((SAMLAttributeDataImpl)sAMLAttributeData).valuesToString(string));
        }
        return hashMap;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        Iterator<SAMLAttributeData> iterator = this.attributeData.iterator();
        SAMLAttributeData sAMLAttributeData = iterator.next();
        if (this.size() == 1) {
            return sAMLAttributeData.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(sAMLAttributeData.toString());
        while (iterator.hasNext()) {
            stringBuffer.append("\n");
            stringBuffer.append(iterator.next().toString());
        }
        return stringBuffer.toString();
    }
}

