/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import java.io.CharArrayWriter;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.security.utils.SAMLAssertionInfo;
import weblogic.security.utils.SAMLAssertionInfoFactory;
import weblogic.wsee.security.saml.CSSUtils;
import weblogic.wsee.security.saml.SAMLAssertionInfoImpl;
import weblogic.wsee.security.saml.SAMLAttributeStatementData;
import weblogic.wsee.security.saml.SAMLCredential;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.common.keyinfo.EncryptedKeyProvider;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.dsig.api.keyinfo.X509Data;
import weblogic.xml.crypto.dsig.keyinfo.KeyInfoImpl;
import weblogic.xml.crypto.encrypt.api.keyinfo.EncryptedKey;
import weblogic.xml.crypto.wss.SecurityImpl;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.dom.DOMStreamReader;
import weblogic.xml.dom.DOMUtils;

public class SAMLCredentialImpl
implements SAMLCredential {
    private static final boolean verbose = Verbose.isVerbose(SAMLCredentialImpl.class);
    private static final boolean debug = false;
    private static final boolean DEBUG_SX_INTEROP_ISSUED_TOKEN = false;
    private Key symmetircKey;
    private PrivateKey privateKey;
    private X509Certificate cert;
    private Key holderOfKey;
    private boolean isHolderOfKey;
    private Element encryptedKey;
    private EncryptedKeyProvider encryptedKeyProvider;
    private String tokenType;
    private String version;
    private boolean isSaml2;
    private Object credential;
    private SAMLAssertionInfo samlAsst;
    private SecurityTokenReference securityTokenReference;
    private SAMLAttributeStatementData attributes;

    protected SAMLCredentialImpl() throws WSSecurityException {
        this.symmetircKey = null;
        this.privateKey = null;
        this.cert = null;
        this.holderOfKey = null;
        this.isHolderOfKey = false;
        this.encryptedKey = null;
        this.encryptedKeyProvider = null;
        this.tokenType = null;
        this.version = null;
        this.isSaml2 = false;
        this.credential = null;
        this.samlAsst = null;
        this.attributes = null;
    }

    public SAMLCredentialImpl(Node node) throws WSSecurityException {
        this(null, node);
    }

    public SAMLCredentialImpl(String string, Object object) throws WSSecurityException {
        this(string, object, null);
    }

    public void verbose() {
        if (verbose) {
            Verbose.log("Assertion ID: " + this.samlAsst.getId());
            Verbose.log("Assertion CM: " + this.samlAsst.getSubjectConfirmationMethod());
            Verbose.log("Assertion Subject: " + this.samlAsst.getSubjectName());
            Verbose.log("Assertion Version: " + this.samlAsst.getVersion());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SAMLCredentialImpl(String string, Object object, PrivateKey privateKey) throws WSSecurityException {
        Element element;
        Object object2;
        block19: {
            this.symmetircKey = null;
            this.privateKey = null;
            this.cert = null;
            this.holderOfKey = null;
            this.isHolderOfKey = false;
            this.encryptedKey = null;
            this.encryptedKeyProvider = null;
            this.tokenType = null;
            this.version = null;
            this.isSaml2 = false;
            this.credential = null;
            this.samlAsst = null;
            this.attributes = null;
            if (verbose) {
                Verbose.log("tokenType: " + string + ", cred: " + object + ", privkey: " + privateKey);
            }
            if (verbose) {
                Verbose.log("Class of cred is: " + object.getClass().toString());
            }
            object2 = object;
            element = null;
            DocumentBuilder documentBuilder = null;
            try {
                try {
                    block18: {
                        if (verbose) {
                            Verbose.log("Instantiating SAMLAssertionInfoFactory");
                        }
                        SAMLAssertionInfoFactory sAMLAssertionInfoFactory = SAMLAssertionInfoFactory.getInstance();
                        if (object instanceof Node) {
                            documentBuilder = CSSUtils.getParser();
                            Document document = documentBuilder.newDocument();
                            Node node = document.importNode((Node)object, true);
                            document.appendChild(node);
                            try {
                                if (verbose) {
                                    Verbose.log("Getting SAMLAssertionInfo from DOM Element of CSS");
                                }
                                this.samlAsst = sAMLAssertionInfoFactory.getSAMLAssertionInfo((Element)node);
                                element = SAMLAssertionInfoImpl.getSamlAssertionSignatureKeyInfoElement((Element)node);
                            }
                            catch (Exception exception) {
                                if (verbose) {
                                    Verbose.log("Got erroron on SAMLAssertionInfo from DOM Element of CSS, msg =" + exception.getMessage());
                                }
                                break block18;
                            }
                        }
                        if (!(object instanceof String)) {
                            throw new WSSecurityException("Invalid SAML token", WSSConstants.FAILURE_TOKEN_INVALID);
                        }
                        if (verbose) {
                            Verbose.log("Getting SAMLAssertionInfo from String XML");
                        }
                        this.samlAsst = sAMLAssertionInfoFactory.getSAMLAssertionInfo((String)object);
                    }
                    if (this.samlAsst == null) {
                        throw new WSSecurityException("Invalid SAML token when samlAsst= null", WSSConstants.FAILURE_TOKEN_INVALID);
                    }
                    Object var12_12 = null;
                    if (documentBuilder == null) break block19;
                }
                catch (Exception exception) {
                    throw new WSSecurityException("Invalid SAML token on CCS?" + exception.getMessage(), exception, WSSConstants.FAILURE_TOKEN_INVALID);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (documentBuilder != null) {
                    CSSUtils.returnParser(documentBuilder);
                }
                throw throwable;
            }
            CSSUtils.returnParser(documentBuilder);
        }
        if (verbose) {
            Verbose.log("Got SAMLAssertionInfo");
        }
        this.setVersion(this.samlAsst.getVersion());
        if (string == null) {
            string = this.isSaml2() ? "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0" : "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
        }
        this.setTokenType(string);
        this.setPrivateKey(privateKey);
        this.setCredential(object2);
        this.initHolderOfKey(this.samlAsst, element);
    }

    private static String toXMLString(Node node) throws TransformerException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        Transformer transformer = null;
        transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(node), new StreamResult(charArrayWriter));
        charArrayWriter.flush();
        return charArrayWriter.toString();
    }

    private void setVersion(String string) {
        this.version = string;
        this.isSaml2 = string.equals("2.0");
    }

    public SAMLAttributeStatementData getAttributes() {
        return this.attributes;
    }

    public void setAttributes(SAMLAttributeStatementData sAMLAttributeStatementData) {
        this.attributes = sAMLAttributeStatementData;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSaml2() {
        return this.isSaml2;
    }

    public String getAssertionID() {
        return this.samlAsst.getId();
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String string) {
        this.tokenType = string;
    }

    public void setCredential(Object object) {
        this.credential = object;
    }

    public Object getCredential() {
        return this.credential;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public boolean isHolderOfKey() {
        return this.isHolderOfKey;
    }

    public Key getHolderOfKey() {
        return this.holderOfKey;
    }

    public Key getSymmetircKey() {
        return this.symmetircKey;
    }

    public void setSymmetircKey(Key key) {
        this.symmetircKey = key;
    }

    public Element getEncryptedKey() {
        return this.encryptedKey;
    }

    public EncryptedKeyProvider getEncryptedKeyProvider() {
        return this.encryptedKeyProvider;
    }

    public void setEncryptedKeyProvider(EncryptedKeyProvider encryptedKeyProvider) {
        this.encryptedKeyProvider = encryptedKeyProvider;
    }

    public X509Certificate getX509Cert() {
        return this.cert;
    }

    private void initHolderOfKey(SAMLAssertionInfo sAMLAssertionInfo, Element element) throws WSSecurityException {
        String string = sAMLAssertionInfo.getSubjectConfirmationMethod();
        this.isHolderOfKey = this.isSaml2() && "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key".equals(string) || !this.isSaml2() && "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key".equals(string);
        this.holderOfKey = null;
        Element element2 = null;
        if (!this.isHolderOfKey) {
            if (null != element) {
                element2 = element;
            }
        } else {
            element2 = sAMLAssertionInfo.getSubjectKeyInfo();
        }
        if (element2 != null) {
            this.encryptedKey = DOMUtils.getFirstElement(element2, SecurityImpl.ENCRYPTED_KEY_QNAME);
            if (this.encryptedKey != null) {
                if (verbose) {
                    Verbose.log("Got Encrypted Key =" + this.encryptedKey);
                }
                return;
            }
            try {
                DOMStreamReader dOMStreamReader = new DOMStreamReader(element2);
                KeyInfoImpl keyInfoImpl = new KeyInfoImpl();
                keyInfoImpl.read(dOMStreamReader);
                this.setKeyObjectFromKeyInfo(keyInfoImpl);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WSSecurityException("Invalid SAML token on XML " + xMLStreamException.getMessage(), xMLStreamException, WSSConstants.FAILURE_TOKEN_INVALID);
            }
            catch (MarshalException marshalException) {
                throw new WSSecurityException("Invalid SAML token  on Marshal " + marshalException.getMessage(), marshalException, WSSConstants.FAILURE_TOKEN_INVALID);
            }
        }
    }

    private Key setKeyObjectFromKeyInfo(KeyInfo keyInfo) {
        List list = keyInfo.getContent();
        for (Object e2 : list) {
            if (e2 instanceof X509Data) {
                X509Data x509Data = (X509Data)e2;
                for (Object e2 : x509Data.getContent()) {
                    if (!(e2 instanceof X509Certificate)) continue;
                    this.cert = (X509Certificate)e2;
                    this.holderOfKey = ((X509Certificate)e2).getPublicKey();
                }
                continue;
            }
            if (e2 instanceof SecurityTokenReference) {
                this.securityTokenReference = (SecurityTokenReference)e2;
                continue;
            }
            if (!(e2 instanceof EncryptedKey) || !verbose) continue;
            Verbose.log("Got another EncryptedKey object here???? ");
        }
        return null;
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.securityTokenReference;
    }
}

