/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.security.saml.SAMLUtils;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wss.policy.GeneralPolicy;
import weblogic.wsee.security.wssc.dk.DKClaims;
import weblogic.wsee.security.wssp.IssuedTokenAssertion;
import weblogic.wsee.security.wst.binding.AlgorithmUri;
import weblogic.wsee.security.wst.binding.CanonicalizationAlgorithm;
import weblogic.wsee.security.wst.binding.EncryptWith;
import weblogic.wsee.security.wst.binding.EncryptionAlgorithm;
import weblogic.wsee.security.wst.binding.KeySize;
import weblogic.wsee.security.wst.binding.KeyType;
import weblogic.wsee.security.wst.binding.SecondaryParameters;
import weblogic.wsee.security.wst.binding.SignWith;
import weblogic.wsee.security.wst.binding.TokenType;
import weblogic.wsee.security.wst.internal.v13.WSTConstants;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.policy.ClaimsBuilder;
import weblogic.xml.dom.DOMProcessingException;

public class SAMLIssuedTokenHelper {
    public static final String ISSUED_TOKEN_POLICY = "IssuedTokenPolicy";
    public static final String ISSUER_URI = "IssuerUri";
    public static final String REQ_INTERNAL_REFERENCE = "RequireInternalReference";
    public static final String REQ_EXTERNAL_REFERENCE = "RequireExternalReference";
    public static final String TRUST_VERSION = "TrustVersion";
    public static final QName ISSUED_TK_POLICY_QNAME = new QName("http://www.bea.com/wls90/security/policy", "IssuedTokenPolicy");
    public static final String TRUST_VERSOIN_10 = "http://schemas.xmlsoap.org/ws/2005/02/trust";
    public static final String TRUST_VERSOIN_13 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    public static final QName TRUST13_TOKEN_TYPE = WSTConstants.T13_TOKEN_TYPE;
    public static final QName TRUST10_TOKEN_TYPE = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "TokenType");
    public static final QName TRUST13_KEY_TYPE = WSTConstants.T13_KEY_TYPE;
    public static final QName TRUST13_KEY_SIZE = WSTConstants.T13_KEY_SIZE;
    public static final QName TRUST13_C14N_ALGO = WSTConstants.T13_C14N_ALGO;
    public static final QName TRUST13_ENC_ALGO = WSTConstants.T13_ENC_ALGO;
    public static final QName TRUST13_ENC_WITH = WSTConstants.T13_ENC_WITH;
    public static final QName TRUST13_SIGN_WITH = WSTConstants.T13_SIGN_WITH;
    private static final boolean debug = false;
    private boolean requireInternalReference = false;
    private boolean requireExternalReference = false;
    private String issuerAddressUri = null;
    private String trustVersion = null;
    private Map templateMap;
    private String namespaceUri;

    public SAMLIssuedTokenHelper(Element element) {
        NodeList nodeList;
        if (null == element) {
            return;
        }
        this.issuerAddressUri = element.getAttribute(ISSUER_URI);
        if ("".equals(this.issuerAddressUri)) {
            this.issuerAddressUri = null;
        }
        this.trustVersion = element.getAttribute(TRUST_VERSION);
        if ("".equals(this.trustVersion)) {
            this.trustVersion = null;
        }
        if ("true".equals(element.getAttribute(REQ_EXTERNAL_REFERENCE))) {
            this.requireExternalReference = true;
        }
        if ("true".equals(element.getAttribute(REQ_INTERNAL_REFERENCE))) {
            this.requireInternalReference = true;
        }
        if ((nodeList = element.getChildNodes()) != null) {
            this.templateMap = new HashMap();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element2 = (Element)node;
                QName qName = DOMUtils.getQName(node);
                if (this.namespaceUri == null) {
                    this.namespaceUri = qName.getNamespaceURI();
                }
                String string = DOMUtils.getText(element2);
                this.templateMap.put(qName, string);
            }
        }
    }

    public boolean isRequireInternalReference() {
        return this.requireInternalReference;
    }

    public boolean isRequireExternalReference() {
        return this.requireExternalReference;
    }

    public String getIssuerAddressUri() {
        return this.issuerAddressUri;
    }

    public String getTrustVersion() {
        return this.trustVersion;
    }

    public String getRequestSecurityTokenTemplateVale(QName qName) {
        if (null == this.templateMap) {
            return null;
        }
        return (String)this.templateMap.get(qName);
    }

    public String getTokenType() {
        String string = this.getRequestSecurityTokenTemplateVale(TRUST13_TOKEN_TYPE);
        if (null == string) {
            return this.getRequestSecurityTokenTemplateVale(TRUST10_TOKEN_TYPE);
        }
        return string;
    }

    public SecondaryParameters biuldSecondaryParameters() {
        AlgorithmUri algorithmUri;
        Object object;
        Object object2;
        Object object3;
        SecondaryParameters secondaryParameters = new SecondaryParameters(this.namespaceUri);
        if (this.templateMap == null || this.templateMap.isEmpty()) {
            return secondaryParameters;
        }
        String string = this.getTokenType();
        if (null != string) {
            object3 = new TokenType(this.namespaceUri);
            ((TokenType)object3).setTokenType(string);
            secondaryParameters.setTokenType((TokenType)object3);
        }
        if (null != (object3 = this.getKeyType())) {
            object2 = new KeyType(this.namespaceUri);
            ((KeyType)object2).setKeyType((String)object3);
            secondaryParameters.setKeyType((KeyType)object2);
        }
        if (null != (object2 = this.getRequestSecurityTokenTemplateVale(TRUST13_KEY_SIZE))) {
            object = new KeySize(this.namespaceUri);
            ((KeySize)object).setSize(Integer.parseInt((String)object2));
            secondaryParameters.setKeySize((KeySize)object);
        }
        if (null != (object = this.getRequestSecurityTokenTemplateVale(TRUST13_C14N_ALGO))) {
            algorithmUri = new CanonicalizationAlgorithm(this.namespaceUri);
            algorithmUri.setUri((String)object);
            secondaryParameters.setCanonicalizationAlgorithm((CanonicalizationAlgorithm)algorithmUri);
        }
        if (null != (object = this.getRequestSecurityTokenTemplateVale(TRUST13_ENC_ALGO))) {
            algorithmUri = new EncryptionAlgorithm(this.namespaceUri);
            algorithmUri.setUri((String)object);
            secondaryParameters.setEncryptionAlgorithm((EncryptionAlgorithm)algorithmUri);
        }
        if (null != (object = this.getRequestSecurityTokenTemplateVale(TRUST13_ENC_WITH))) {
            algorithmUri = new EncryptWith(this.namespaceUri);
            algorithmUri.setUri((String)object);
            secondaryParameters.setEncryptWith((EncryptWith)algorithmUri);
        }
        if (null != (object = this.getRequestSecurityTokenTemplateVale(TRUST13_SIGN_WITH))) {
            algorithmUri = new SignWith(this.namespaceUri);
            algorithmUri.setUri((String)object);
            secondaryParameters.setSignWith((SignWith)algorithmUri);
        }
        return secondaryParameters;
    }

    public String getKeyType() {
        return this.getRequestSecurityTokenTemplateVale(TRUST13_KEY_TYPE);
    }

    public int getKeySize() {
        String string = this.getRequestSecurityTokenTemplateVale(TRUST13_KEY_SIZE);
        if (null == string) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    public static Element makeIssuedTokenClaimElement(IssuedTokenAssertion issuedTokenAssertion) throws SecurityPolicyException {
        Element element = DKClaims.makeClaimsNode();
        return SAMLIssuedTokenHelper.makeIssuedTokenClaimElement(issuedTokenAssertion, element, null);
    }

    public static Element makeIssuedTokenClaimElement(IssuedTokenAssertion issuedTokenAssertion, Node node, String string) {
        if (null == node || null == issuedTokenAssertion) {
            return null;
        }
        Element element = DOMUtils.createAndAddElement((Element)node, ISSUED_TK_POLICY_QNAME, node.getPrefix());
        String string2 = issuedTokenAssertion.getIssuerString();
        if (null != string2) {
            element.setAttribute(ISSUER_URI, string2);
        }
        if (issuedTokenAssertion.isRequireExternalReference()) {
            element.setAttribute(REQ_EXTERNAL_REFERENCE, "true");
        }
        if (issuedTokenAssertion.isRequireInternalReference()) {
            element.setAttribute(REQ_INTERNAL_REFERENCE, "true");
        }
        if (issuedTokenAssertion.hasRequestSecurityTokenTemplate()) {
            Map map = issuedTokenAssertion.getRequestSecurityTokenTemplate().getTemplateMap();
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                Element element2 = DOMUtils.createAndAddElement(element, (QName)entry.getKey(), node.getPrefix());
                DOMUtils.addText(element2, (String)entry.getValue());
            }
            if (map.get(TRUST13_TOKEN_TYPE) != null) {
                string = TRUST_VERSOIN_13;
            } else if (map.get(TRUST10_TOKEN_TYPE) != null) {
                string = TRUST_VERSOIN_10;
            }
        }
        if (null != string) {
            element.setAttribute(TRUST_VERSION, string);
        }
        return element;
    }

    public static String getTrustVersionFromPolicy(GeneralPolicy generalPolicy) {
        String string = null;
        if (generalPolicy.hasTrustOptions()) {
            string = generalPolicy.getTrustOptions().isWst10() ? TRUST_VERSOIN_10 : TRUST_VERSOIN_10;
        }
        return string;
    }

    public static String getClaimFromChildElt(Node node, String string) {
        if (node == null || !(node instanceof Element)) {
            return null;
        }
        try {
            Element element = weblogic.xml.dom.DOMUtils.getElementByTagName((Element)node, string);
            if (null == element) {
                return null;
            }
            return weblogic.xml.dom.DOMUtils.getTextContent(element, true);
        }
        catch (DOMProcessingException dOMProcessingException) {
            return null;
        }
    }

    public static String getKeyTypeFromClaims(Node node) {
        if (node == null) {
            return null;
        }
        return SAMLIssuedTokenHelper.getClaimFromChildElt(node, "KeyType");
    }

    public static String getTrustKeyTypeFromIssuedTokenClaims(Node node) {
        if (node == null) {
            return null;
        }
        return ClaimsBuilder.getClaimFromElt(node, WSTConstants.T13_KEY_TYPE);
    }

    public static boolean isSymmetricKeyTypeFromIssuedTokenClaim(Node node) {
        String string = SAMLIssuedTokenHelper.getTrustKeyTypeFromIssuedTokenClaims(node);
        return SAMLUtils.isSymmetricKeyType(string);
    }

    private static String getValueFromFromIssuedTokenClaims(Node node, QName qName, String string) {
        if (node == null) {
            return string;
        }
        String string2 = ClaimsBuilder.getClaimFromElt(node, qName);
        if (null == string2) {
            return string;
        }
        return string2;
    }
}

