/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.common.keyinfo.BaseKeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeySelectorResultImpl;
import weblogic.xml.crypto.utils.KeyUtils;
import weblogic.xml.crypto.wss.provider.SecurityToken;

public class SAMLKeyProvider
extends BaseKeyProvider {
    private String[] algs;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private static final boolean verbose = Verbose.isVerbose(SAMLKeyProvider.class);

    public SAMLKeyProvider(PublicKey publicKey, PrivateKey privateKey, String string, SecurityToken securityToken) {
        super(null, string.getBytes(), "#" + string, securityToken);
        if (verbose) {
            Verbose.log("Public key is: " + (publicKey == null ? "null" : "not null"));
            Verbose.log("Private key is: " + (privateKey == null ? "null" : "not null"));
            Verbose.log("Assertion ID is: " + string);
            Verbose.log("SecurityToken is: " + securityToken);
        }
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.algs = this.publicKey != null ? KeyUtils.getAlgorithms(this.publicKey) : KeyUtils.getAlgorithms(privateKey);
    }

    public KeySelectorResult getKey(String string, KeySelector.Purpose purpose) {
        if (KeyUtils.supports(this.algs, string)) {
            if (this.privateKey != null && KeyUtils.serves(KeyUtils.getPurposes(this.privateKey), purpose)) {
                return this.getResult(this.privateKey);
            }
            if (this.publicKey != null && KeyUtils.serves(KeyUtils.getPurposes(this.publicKey), purpose)) {
                return this.getResult(this.publicKey);
            }
        }
        return null;
    }

    protected KeySelectorResult getResult(Key key) {
        KeySelectorResultImpl keySelectorResultImpl = new KeySelectorResultImpl(key);
        keySelectorResultImpl.setSecurityToken(this.getSecurityToken());
        return keySelectorResultImpl;
    }
}

