/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.saml;

import java.io.Serializable;
import java.io.StringBufferInputStream;
import weblogic.kernel.KernelStatus;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.saml.SAMLCredential;
import weblogic.wsee.security.saml.SAMLToken;
import weblogic.wsee.security.saml.SAMLTokenHandler;
import weblogic.wsee.security.saml.SAMLTrustCredentialProvider;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.faults.WSTFaultUtil;
import weblogic.wsee.security.wst.framework.TrustSoapClient;
import weblogic.wsee.security.wst.framework.WSTContext;

public class SAMLSTSHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final SAMLToken performHandshake(SoapMessageContext soapMessageContext) {
        SAMLToken sAMLToken;
        NormalizedExpression normalizedExpression;
        block10: {
            NormalizedExpression normalizedExpression2 = (NormalizedExpression)soapMessageContext.getProperty("weblogic.wsee.policy.effectiveRequestPolicy");
            normalizedExpression = (NormalizedExpression)soapMessageContext.getProperty("weblogic.wsee.policy.effectiveResponsePolicy");
            try {
                try {
                    Serializable serializable;
                    if (soapMessageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx") == null) {
                        serializable = new WssPolicyContext(KernelStatus.isServer());
                        soapMessageContext.setProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx", serializable);
                    }
                    serializable = WSTContext.getWSTContext(soapMessageContext);
                    String string = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
                    ((WSTContext)serializable).setTokenType(string);
                    ((WSTContext)serializable).initEndpoints(soapMessageContext);
                    ((WSTContext)serializable).setTrustVersion("http://schemas.xmlsoap.org/ws/2005/02/trust");
                    ((WSTContext)serializable).setAction(SAMLSTSHelper.getAction("http://schemas.xmlsoap.org/ws/2005/02/trust"));
                    ((WSTContext)serializable).setWssp(false);
                    ((WSTContext)serializable).setBootstrapPolicy(SAMLSTSHelper.getTrustBootStrapPolicy(false));
                    TrustSoapClient trustSoapClient = new TrustSoapClient((WSTContext)serializable);
                    SAMLCredential sAMLCredential = SAMLTrustCredentialProvider.createCredential(trustSoapClient, (WSTContext)serializable, new SAMLTokenHandler(), string);
                    soapMessageContext.setProperty("weblogic.wsee.saml.credential", sAMLCredential);
                    StringBufferInputStream stringBufferInputStream = new StringBufferInputStream("<?xml version=\"1.0\"?>\n\n<wsp:Policy\n  xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"\n  xmlns:wssp=\"http://www.bea.com/wls90/security/policy\"\n  xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"\n  xmlns:wls=\"http://www.bea.com/wls90/security/policy/wsee#part\"\n  >\n\n  <wssp:Identity>\n    <wssp:SupportedTokens>\n <wssp:SecurityToken  TokenType=\"http://docs.oasis-open.org/wss/2004/01/oasis-2004-01-saml-token-profile-1.0#SAMLAssertionID\">\n        <wssp:Claims>\n          <wssp:ConfirmationMethod>sender-vouches</wssp:ConfirmationMethod>\n        </wssp:Claims>\n      </wssp:SecurityToken>    </wssp:SupportedTokens>\n  </wssp:Identity>\n</wsp:Policy>");
                    NormalizedExpression normalizedExpression3 = PolicyFinder.readPolicyFromStream(null, "SAMLPolicy.xml", stringBufferInputStream, true).normalize();
                    sAMLToken = (SAMLToken)trustSoapClient.generateTrustToken(soapMessageContext, normalizedExpression3, string);
                    Object var11_12 = null;
                    if (normalizedExpression2 == null) break block10;
                }
                catch (WSTFaultException wSTFaultException) {
                    wSTFaultException.printStackTrace();
                    WSTFaultUtil.raiseFault(wSTFaultException);
                    Object var11_13 = null;
                    if (normalizedExpression2 != null) {
                        soapMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", normalizedExpression2);
                    }
                    if (normalizedExpression == null) return null;
                    soapMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", normalizedExpression);
                    return null;
                }
                catch (PolicyException policyException) {
                    WSTFaultUtil.raiseFault(new WSTFaultException(policyException.getMessage()));
                    Object var11_14 = null;
                    if (normalizedExpression2 != null) {
                        soapMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", normalizedExpression2);
                    }
                    if (normalizedExpression == null) return null;
                    soapMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", normalizedExpression);
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (normalizedExpression2 != null) {
                    soapMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", normalizedExpression2);
                }
                if (normalizedExpression == null) throw throwable;
                soapMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", normalizedExpression);
                throw throwable;
            }
            soapMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", normalizedExpression2);
        }
        if (normalizedExpression == null) return sAMLToken;
        soapMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", normalizedExpression);
        return sAMLToken;
    }

    public static String getAction(String string) {
        return string + "/RST" + "/Issue";
    }

    private static String getRequestType(String string) {
        return string + "/Issue";
    }

    public static NormalizedExpression getTrustBootStrapPolicy(boolean bl) {
        NormalizedExpression normalizedExpression = NormalizedExpression.createUnitializedExpression();
        if (!bl) {
            try {
                PolicyServer policyServer = new PolicyServer();
                normalizedExpression = policyServer.getPolicy("SecurityTokenService.xml").normalize();
            }
            catch (PolicyException policyException) {
                // empty catch block
            }
        }
        return normalizedExpression;
    }
}

